/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Strings;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.SeeTree;
import com.xebialabs.commons.html.Element;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDocWriter;
import com.xebialabs.gradle.plugins.restdoclet.doclet.scanner.MethodScanner;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RestServiceWriter
extends RestDocWriter {
    private final TypeElement service;
    private final boolean printJsonContentType;
    private final String path;
    private final String defaultConsumes;
    private final String defaultProduces;

    public RestServiceWriter(PrintWriter writer, TypeElement service, boolean printJsonContentType) {
        super(writer);
        this.service = service;
        this.printJsonContentType = printJsonContentType;
        this.path = RestServiceWriter.getPath(service);
        this.defaultConsumes = this.getConsumes(service);
        this.defaultProduces = this.getProduces(service);
    }

    public void writeRestService() {
        this.writeHeader();
        this.writeIndex();
        this.writeMethodDetails();
    }

    private void writeHeader() {
        this.div(new Object[]{this.h1(new Object[]{this.service.getSimpleName().toString()})}).cssClass("manual-title").write();
        this.writeDeprecationDetails(this.service);
        this.p(new Object[]{this.asText(this.getDocTree(this.service)) + this.parseRestDetails(this.service)}).write();
    }

    private void writeIndex() {
        this.table(new Object[0]).cssClass("parameter-table").writeOpen();
        for (ExecutableElement method : RestServiceWriter.getRestMethods(this.service)) {
            String httpMethod = RestServiceWriter.getHttpMethod(method);
            this.row(new Object[]{httpMethod, this.link("#" + this.getAnchor(method), new Object[]{this.getUri(method)}), this.asText(this.getDocTree(method))}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    private void writeMethodDetails() {
        this.hr().write();
        for (ExecutableElement method : RestServiceWriter.getRestMethods(this.service)) {
            this.writeMethodDetail(method);
        }
    }

    private void writeMethodDetail(ExecutableElement method) {
        this.anchor(this.getAnchor(method), new Object[0]).write();
        this.h2(new Object[]{RestServiceWriter.getHttpMethod(method), " ", this.getUri(method)}).cssClass("resource-header").write();
        this.p(new Object[]{this.asText(this.getDeprecatedTags(method))}).write();
        String restDetails = this.parseRestDetails(method);
        this.div(new Object[]{this.asText(this.getDocTree(method)) + restDetails}).write();
        this.writePermissions(method);
        this.writeHeaders(method);
        this.writeParameters(method);
        this.writeReturnType(method);
        List<DocTree> seeDocTree = this.getSeeTags(method);
        for (DocTree seeTag : seeDocTree) {
            List<? extends DocTree> seeTreeReferenceList = ((SeeTree)seeTag).getReference();
            this.definitionList("See", new Object[]{this.asText(seeTreeReferenceList)}).write();
        }
    }

    private void writeHeaders(ExecutableElement method) {
        List<DocTree> headersDocTree = this.getHeadersTags(method);
        Element dt = this.definitionList("Headers", new Object[0]);
        if (!headersDocTree.isEmpty()) {
            for (DocTree header : headersDocTree) {
                dt.add(new Object[]{this.element("dd", new Object[]{this.italic(new Object[]{RestServiceWriter.firstWord(header)}), RestServiceWriter.restOfSentence(header)})});
            }
            dt.write();
        }
    }

    private void writePermissions(ExecutableElement method) {
        List<DocTree> permissionDocTree = this.getPermissionTags(method);
        if (!permissionDocTree.isEmpty()) {
            Element dt = this.definitionList("Permissions", new Object[0]);
            for (DocTree permission : permissionDocTree) {
                Object rest = RestServiceWriter.restOfSentence(permission);
                if (!Strings.isNullOrEmpty((String)rest)) {
                    rest = " - " + (String)rest;
                }
                dt.add(new Object[]{this.element("dd", new Object[]{this.code(new Object[]{RestServiceWriter.firstWord(permission)}), rest})});
            }
            dt.write();
        }
    }

    private String parseRestDetails(javax.lang.model.element.Element element) {
        List<DocTree> restDetails = this.getRestDetailsTags(element);
        if (restDetails.isEmpty()) {
            return "";
        }
        return " " + this.asText(restDetails);
    }

    private void writeDeprecationDetails(javax.lang.model.element.Element element) {
        Element p = this.p(new Object[]{this.element("strong", new Object[]{"Deprecated:"})});
        List<DocTree> deprecatedTags = this.getDeprecatedTags(element);
        if (!deprecatedTags.isEmpty()) {
            p.add(new Object[]{this.italic(new Object[]{this.asText(deprecatedTags)})});
            p.write();
        }
    }

    private void writeReturnType(ExecutableElement method) {
        if ("void".equals(method.getReturnType().toString())) {
            this.definitionList("Response body", new Object[]{this.italic(new Object[]{"Empty"})}).write();
        } else {
            this.definitionList("Response body", new Object[]{this.renderType(method.getReturnType()) + this.getReturnTypeInfo(method), "Content type: " + this.getMethodProduces(method)}).write();
        }
    }

    private String getReturnTypeInfo(ExecutableElement method) {
        List<DocTree> returnTypeDocTree = this.getReturnTags(method);
        if (returnTypeDocTree.isEmpty()) {
            return "";
        }
        return " - " + this.asText(returnTypeDocTree);
    }

    private void writeParameters(ExecutableElement method) {
        List<? extends VariableElement> paramElements = method.getParameters();
        if (paramElements.isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("parameter-table");
        for (VariableElement variableElement : paramElements) {
            ParameterInfo info = this.getParameterInfo(method, variableElement);
            if (info == null) {
                System.out.println("Warning: No actual parameter for @param " + variableElement.getSimpleName().toString() + " on " + method);
                continue;
            }
            List<DocTree> allParamTreeList = this.getParamTags(method);
            List<Object> filteredElementForRow = new ArrayList();
            if (!allParamTreeList.isEmpty()) {
                filteredElementForRow = allParamTreeList.stream().filter(p -> p.toString().contains(paramElement.toString())).collect(Collectors.toList());
            }
            table.add(new Object[]{this.row(new Object[]{this.italic(new Object[]{info.kind}), info.name, this.renderType(info.type), this.asText(filteredElementForRow)})});
        }
        this.definitionList("Parameters", new Object[]{table}).write();
    }

    private static List<ExecutableElement> getRestMethods(TypeElement service) {
        MethodScanner scanner = new MethodScanner();
        scanner.scan((javax.lang.model.element.Element)service, null);
        return scanner.getMethods().stream().filter(RestServiceWriter::isRestMethod).sorted(new MethodComparator()).collect(Collectors.toList());
    }

    private static boolean isRestMethod(javax.lang.model.element.Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().toString().startsWith("javax.ws.rs")) continue;
            return true;
        }
        return false;
    }

    private static String getPath(javax.lang.model.element.Element element) {
        return RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Path");
    }

    private String getUri(javax.lang.model.element.Element element) {
        return this.path + "/" + RestServiceWriter.getPath(element);
    }

    private String getAnchor(javax.lang.model.element.Element element) {
        return this.getUri(element) + ":" + RestServiceWriter.getHttpMethod(element);
    }

    private String getConsumes(javax.lang.model.element.Element element) {
        return this.optionallyStripJson(RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Consumes").replace("\"", "").replaceAll("[\"\\]\\[]", ""));
    }

    private String optionallyStripJson(String s) {
        if (!this.printJsonContentType) {
            return s.replace("application/json", "").replaceAll(",\\s*$", "");
        }
        return s;
    }

    private String getMethodConsumes(ExecutableElement method) {
        String consumes = this.getConsumes(method);
        if (Strings.isNullOrEmpty((String)consumes)) {
            return this.defaultConsumes;
        }
        return consumes;
    }

    private String getProduces(javax.lang.model.element.Element element) {
        return this.optionallyStripJson(RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Produces").replaceAll("[\"\\]\\[]", ""));
    }

    private String getMethodProduces(ExecutableElement method) {
        String produces = this.getProduces(method);
        if (Strings.isNullOrEmpty((String)produces)) {
            return this.defaultProduces;
        }
        return produces;
    }

    private static String getHttpMethod(javax.lang.model.element.Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.GET")) {
                return "GET";
            }
            if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.POST")) {
                return "POST";
            }
            if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.PUT")) {
                return "PUT";
            }
            if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.DELETE")) {
                return "DELETE";
            }
            if (!annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.HEAD")) continue;
            return "HEAD";
        }
        return "?";
    }

    public static String getAnnotationValue(javax.lang.model.element.Element element, String annotationType) {
        return RestServiceWriter.getAnnotationValue(RestServiceWriter.getAnnotation(element, annotationType));
    }

    private static String getAnnotationValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Iterator<? extends AnnotationValue> iterator = annotation.getElementValues().values().iterator();
        if (iterator.hasNext()) {
            AnnotationValue item = iterator.next();
            Object value = item.getValue();
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value).toString();
            }
            return value.toString();
        }
        return "";
    }

    private static AnnotationMirror getAnnotation(javax.lang.model.element.Element element, String type) {
        return element.getAnnotationMirrors().stream().filter(mirror -> mirror.getAnnotationType().toString().equals(type)).findFirst().orElse(null);
    }

    private ParameterInfo getParameterInfo(ExecutableElement method, VariableElement tag) {
        List<? extends VariableElement> parameters = method.getParameters();
        String name = tag.getSimpleName().toString();
        for (VariableElement variableElement : parameters) {
            if (!variableElement.getSimpleName().toString().equals(name)) continue;
            TypeMirror type = variableElement.asType();
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.PathParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Path", type);
                }
                if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.QueryParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Query", type);
                }
                if (annotationMirror.getAnnotationType().toString().equals("javax.ws.rs.HeaderParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Header", type);
                }
                if (!annotationMirror.getAnnotationType().toString().equals("org.jboss.resteasy.annotations.providers.multipart.MultipartForm")) continue;
                return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Multipart", type);
            }
            return new ParameterInfo(this.getMethodConsumes(method), "Request&nbsp;body", type);
        }
        return null;
    }

    private static class MethodComparator
    implements Comparator<ExecutableElement> {
        private MethodComparator() {
        }

        @Override
        public int compare(ExecutableElement method, ExecutableElement anotherMethod) {
            return RestServiceWriter.getPath(method).compareTo(RestServiceWriter.getPath(anotherMethod));
        }
    }

    private static class ParameterInfo {
        final String name;
        final String kind;
        final TypeMirror type;

        ParameterInfo(String name, String kind, TypeMirror type) {
            this.name = name;
            this.kind = kind;
            this.type = type;
        }
    }
}

