/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDocWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDoclet;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocEnv;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class OverviewWriter
extends RestDocWriter {
    private String productName;

    public OverviewWriter(PrintWriter writer, String productName) {
        super(writer);
        this.productName = productName;
    }

    public void write(List<TypeElement> services) {
        this.writeHeader();
        this.writePackageInfo(services);
        this.writeServices(services);
    }

    private void writePackageInfo(List<TypeElement> services) {
        LinkedHashSet<PackageElement> packages = new LinkedHashSet<PackageElement>();
        for (Element element : services) {
            packages.add(DocEnv.get().getElementUtils().getPackageOf(element));
        }
        for (PackageElement packageElement : packages) {
            DocCommentTree docCommentTree = DocEnv.get().getDocTrees().getDocCommentTree(packageElement);
            List<Object> docTrees = new ArrayList();
            if (docCommentTree != null) {
                docTrees = docCommentTree.getFullBody();
            }
            this.p(new Object[]{this.asText(docTrees)}).write();
        }
    }

    private void writeServices(List<TypeElement> services) {
        this.table(new Object[0]).cssClass("services").writeOpen();
        for (Element element : services) {
            this.row(new Object[]{this.link(RestDoclet.fileNameFor(element.getSimpleName().toString()), new Object[]{element.getSimpleName()}), this.asText(this.getDocTree(element))}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    public void writeHeader() {
        this.div(new Object[]{this.h1(new Object[]{String.format("%s REST API", this.productName)})}).cssClass("manual-title").write();
    }
}

