package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner

import javax.lang.model.element.{Element, ElementKind, Modifier, VariableElement}
import javax.lang.model.util.ElementScanner9
import scala.collection.mutable.ListBuffer

class VariableElementScanner(kind: ElementKind) extends ElementScanner9[Void, Int] {

  val elements = new ListBuffer[VariableElement]

  override def scan(e: Element, depth: Int): Void = {
    e.getKind match {
      case k if kind.equals(k) && 1.equals(depth) && e.getModifiers.contains(Modifier.PUBLIC) => elements.addOne(e.asInstanceOf[VariableElement])
      case _ =>
    }

    super.scan(e, depth + 1)
  }
}
