package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner

import com.sun.source.doctree.{DocTree, ParamTree}
import com.sun.source.util.DocTreeScanner
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocEnv

import javax.lang.model.element.{Element, ElementKind, VariableElement}
import javax.lang.model.util.ElementScanner9
import scala.collection.mutable.ListBuffer

class MethodArgumentScanner extends ElementScanner9[Void, Int] {

  var params = new ListBuffer[VariableElement]()
  var paramDocs = new ListBuffer[ParamTree]()

  override def scan(e: Element, i: Int): Void = {
    e.getKind match {
      case ElementKind.METHOD | ElementKind.CONSTRUCTOR =>
        val methodDocs = DocEnv.get().getDocTrees.getDocCommentTree(e)
        if (methodDocs != null) {
          val scanner = new JavadocArgumentScanner()
          scanner.scan(methodDocs, paramDocs)
        }
      case ElementKind.PARAMETER => params.addOne(e.asInstanceOf[VariableElement])
    }
    super.scan(e, i)
  }

  class JavadocArgumentScanner extends DocTreeScanner[Void, ListBuffer[ParamTree]] {

    override def scan(t: DocTree, params: ListBuffer[ParamTree]): Void = {
      t.getKind match {
        case DocTree.Kind.PARAM => params.addOne(t.asInstanceOf[ParamTree])
        case _ =>
      }
      super.scan(t, params)
    }
  }
}
