package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner

import com.sun.source.doctree.{DocTree, UnknownBlockTagTree}
import com.sun.source.util.DocTreeScanner

import scala.collection.mutable.ListBuffer

class FirstChildrenScanner(requestedKind: KindComparator) extends DocTreeScanner[Void, Boolean] {

  def this(parentKind: Either[DocTree.Kind, String]) {
    this(parentKind match {
      case Left(value) => new TypedKindComparator(value)
      case Right(value) => new StringKindComparator(value)
    })
  }

  val tags = new ListBuffer[DocTree]()

  override def scan(doc: DocTree, atChildLevel: Boolean): Void = {
    if (atChildLevel) {
      tags.addOne(doc)
      super.scan(doc, true)
    } else {
      if (requestedKind.equalToKindOf(doc)) {
        super.scan(doc, true)
      } else {
        super.scan(doc, false)
      }
    }
  }
}

trait KindComparator {
  def equalToKindOf(docTree: DocTree): Boolean
}

class StringKindComparator(kind: String) extends KindComparator {
  private val cleanKind = kind.substring(1) // tags start with @, need to strip this

  override def equalToKindOf(docTree: DocTree): Boolean =
    docTree.getKind match {
      case DocTree.Kind.UNKNOWN_BLOCK_TAG => cleanKind.equals(docTree.asInstanceOf[UnknownBlockTagTree].getTagName)
      case k => false
    }
}

class TypedKindComparator(kind: DocTree.Kind) extends KindComparator {
  override def equalToKindOf(docTree: DocTree): Boolean = kind.equals(docTree.getKind)
}
