package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner;

import javax.lang.model.element.{Element, ElementKind, TypeElement}
import javax.lang.model.util.ElementScanner9
import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters.SeqHasAsJava

class ClassScanner extends ElementScanner9[Void, Void] {

    val desiredKinds = Set(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE)
    val classes = new ListBuffer[TypeElement]

    override def scan(e: Element, unused: Void): Void = {
        if (desiredKinds.contains(e.getKind)) {
            classes.addOne(e.asInstanceOf[TypeElement]);
        }

        super.scan(e, unused);
    }

    def getClasses: java.util.List[TypeElement] = classes.asJava
}
