package com.xebialabs.gradle.plugins.restdoclet.doclet

import com.xebialabs.gradle.plugins.restdoclet.doclet.scanner.ClassScanner
import jdk.javadoc.doclet.DocletEnvironment
import spray.json._

import java.util.{List => JList}
import javax.lang.model.element.TypeElement
import scala.jdk.CollectionConverters._

object DocletUtils extends DocFormats {

  def findAnnotatedClasses(docEnv: DocletEnvironment, annotationClass: String): JList[TypeElement] = {
    val scanner = new ClassScanner()
    scanner.scan(docEnv.getIncludedElements, null)
    scanner.classes
      .filter(e => e.getAnnotationMirrors.stream.anyMatch(m => m.getAnnotationType.toString.equals(annotationClass)))
      .asJava
  }

  def generateJson(classes: JList[TypeElement]): String = {
    classes.asScala.toSeq.toJson.toString()
  }

  def generateAsJsOject(clazz: TypeElement) = {
    clazz.toJson.asJsObject
  }

  def getField(jsObject: JsObject, name: String) = {
    jsObject.getFields(name).head
  }

  def getJsNull = {
    JsNull
  }

  }
