package com.xebialabs.gradle.upload.tasks

import com.xebialabs.overthere.*
import com.xebialabs.overthere.local.LocalFile
import com.xebialabs.overthere.util.OverthereFileCopier
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.TaskAction

class CopyRemote extends DefaultTask {
  @Input
  def hostname
  @Input
  def username
  @Input
  def password
  @Input
  def os
  @Input
  def connectionType
  @Input
  def protocol

  @InputFile
  def destinationPath

  @InputFile
  def source

  @TaskAction
  public void upload() {
    println("Copying ${source} to ${getDestinationPath()}")
    OverthereConnection connection = Overthere.getConnection("${getProtocol()}", buildConnectionOptions());
    try {
      OverthereFile dest = connection.getFile("${getDestinationPath()}");
      OverthereFile src = LocalFile.valueOf(project.file(source));
      if (src.isDirectory()) {
        dest.mkdirs();
      } else {
        dest.parentFile.mkdirs()
      }
      OverthereFileCopier.copy(src, dest);
    } finally {
      closeQuietly(connection)
    }
  }

  private static void closeQuietly(OverthereConnection connection) {
    try {
      connection.close();
    } catch (RuntimeException ignored) {
      // ignored.
    }
  }

  /**
   * Need to have the fields as strings, because they can be closures. So we need to resolve them.
   */
  private ConnectionOptions buildConnectionOptions() {
    ConnectionOptions options = new ConnectionOptions();
    options.set("connectionType", "${getConnectionType()}".toString());
    options.set("os", OperatingSystemFamily.valueOf("${getOs()}"));
    options.set("address", "${getHostname()}".toString());
    options.set("username", "${getUsername()}".toString());
    options.set("password", "${getPassword()}".toString());

    println(options)
    return options;
  }
}
