package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.xebialabs.commons.html.Element;
import com.xebialabs.commons.html.HtmlWriter;

import java.io.PrintWriter;

/**
 * Provides header and footer for generated files.
 */
public class PageTemplate extends HtmlWriter {

    public PageTemplate(PrintWriter writer) {
        super(writer);
    }

    public void writeHeader(String title) {
        Element favicon = element("link")
                .attribute("rel", "icon")
                .attribute("type", "image/ico")
                .attribute("href", "/images/logos/favicon.ico");

        html().writeOpen();
        head(
                favicon,
                title(title),
                linkCss("layout.css"),
                linkCss("restdoc.css")
        ).write();

        // Start body
        FileCatalog.write("html-body-start.html", getWriter());
    }

    public void writeFooter() {
        FileCatalog.write("html-body-end.html", getWriter());
    }
}
