package com.xebialabs.gradle.plugins.restdoclet.doclet

import com.sun.javadoc.{ClassDoc, RootDoc}
import spray.json._

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

object DocletUtils extends DocFormats {


  def generateJson(classes: JList[ClassDoc]): String = {
    classes.asScala.toSeq.toJson.toString()
  }

  def findAnnotatedClasses(rootDoc: RootDoc, annotationClass: String): JList[ClassDoc] = rootDoc.classes().filter(
    c => c.annotations().map(_.annotationType().qualifiedName()).contains(annotationClass)
  ).toList.asJava

  def generateAsJsOject(clazz: ClassDoc) = {
    clazz.toJson.asJsObject
  }

  def getField(jsObject: JsObject, name: String) = {
    jsObject.getFields(name).head
  }

  def getJsNull = {
    JsNull
  }
}
