package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;

import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * Generates the summary page.
 */
public class OverviewWriter extends RestdocWriter {

    private String productName;

    public OverviewWriter(PrintWriter writer, String productName) {
        super(writer);
        this.productName = productName;
    }

    public void write(List<ClassDoc> services) {
        writeHeader();
        writePackageInfo(services);
        writeServices(services);
    }

    private void writePackageInfo(List<ClassDoc> services) {
        // Collect packages
        Set<PackageDoc> packages = new LinkedHashSet<>();
        for (ClassDoc service : services) {
            packages.add(service.containingPackage());
        }

        // Write packages
        for (PackageDoc pack : packages) {
            p(asText(pack.inlineTags())).write();
        }
    }

    private void writeServices(List<ClassDoc> services) {
        table().cssClass("services").writeOpen();

        for (ClassDoc service : services) {
            row(
                    link(RestDoclet.fileNameFor(service), service.name()),
                    asText(getTags(service))
             ).write();
        }

        table().writeClose();
    }

    //
    // Html rendering
    //

    public void writeHeader() {
        div(h1(String.format("%s REST API", productName))).cssClass("manual-title").write();
    }

}
