/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.xebialabs.gradle.documentation.restdoc.doclet.Resource;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;

public class FileCatalog {
    public static final FileCatalog SINGLETON = new FileCatalog();
    private final Set<String> items = new TreeSet<String>();
    private final Set<String> missing = new TreeSet<String>();

    public boolean check(String reference) {
        if (this.items.contains(reference)) {
            return true;
        }
        if (FileCatalog.isResource(reference)) {
            this.items.add(reference);
            return true;
        }
        this.missing.add(reference);
        return false;
    }

    public void add(String reference) {
        this.items.add(reference);
    }

    public static boolean isResource(String reference) {
        return FileCatalog.class.getClassLoader().getResource(FileCatalog.asResourcePath(reference)) != null;
    }

    private static String asResourcePath(String reference) {
        return "restdoc/" + reference;
    }

    public Set<String> getItems() {
        return this.items;
    }

    public Set<String> getMissing() {
        return this.missing;
    }

    public static void write(String item, PrintWriter writer) {
        Resource.fromClasspath(FileCatalog.asResourcePath(item)).write(writer);
    }
}

