package com.xebialabs.gradle.plugins.restdoclet.doclet

import com.sun.javadoc.{Doc, MethodDoc, SeeTag, Tag}

object TagUtils {

  def textFromTags(d: Doc, tags: Array[Tag]): String = {
    tags.foldLeft("")(
      (s, t) => s + (t match {
        case seeTag: SeeTag if seeTag.referencedMember() != null =>
          seeTag.referencedMember() match {
            case referencedMethod: MethodDoc => s"{${seeTag.name()} ${seeTag.referencedClassName()}#${referencedMethod.name()}${referencedMethod.signature()}}"
            case somethingElse => s"{${seeTag.name()} ${seeTag.referencedClassName()}#${somethingElse.name()}}"
          }

        case seeTag: SeeTag if seeTag.referencedClass() != null =>
          s"{${seeTag.name()} ${seeTag.referencedClass().qualifiedName()}}"

        case otherTag: Tag if t.name() == "Text" =>
          t.text

        case seeTag: Tag =>
          s"{${seeTag.name()} ${seeTag.text()}}"

      })
    )
  }

}
