/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Strings;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.FileCatalog;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDoclet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RestdocWriter
extends HtmlWriter {
    private final FileCatalog fileCatalog = FileCatalog.SINGLETON;

    public RestdocWriter(PrintWriter writer) {
        super(writer);
    }

    protected String asText(Tag[] tags) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                this.appendLink(builder, (SeeTag)tag);
                continue;
            }
            if (tag.name().equals("@code")) {
                builder.append(this.code(new Object[]{tag.text()}));
                continue;
            }
            if (tag.name().equals("@deprecated")) {
                builder.append(this.span(new Object[]{"(Deprecated)"}).cssClass("deprecated"));
                continue;
            }
            builder.append(tag.text());
        }
        return builder.toString();
    }

    private void appendLink(StringBuilder builder, SeeTag tag) {
        String file = RestDoclet.fileNameFor(tag.referencedClassName());
        String text = tag.text();
        if (!Strings.isNullOrEmpty((String)tag.label())) {
            text = tag.label();
        }
        if (file != null && this.fileCatalog.check(file)) {
            builder.append(this.link(file, new Object[]{text}));
        } else {
            builder.append(this.bold(new Object[]{text}));
        }
    }

    protected String asText(Type type) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.simpleTypeName());
        String separator = " of ";
        for (Type paramType : this.getParametrizedTypes(type)) {
            builder.append(separator);
            builder.append(paramType.simpleTypeName());
            separator = ", ";
        }
        return builder.toString();
    }

    public static String firstWord(Tag tag) {
        return tag.text().split("\\s")[0];
    }

    public static String restOfSentence(Tag tag) {
        return tag.text().substring(RestdocWriter.firstWord(tag).length());
    }

    protected String asReference(Type type) {
        List<Type> types = this.getParametrizedTypes(type);
        if (types.isEmpty()) {
            return type.qualifiedTypeName() + ".html";
        }
        return types.get(0) + "-" + type.simpleTypeName() + ".html";
    }

    public List<Type> getParametrizedTypes(Type type) {
        ArrayList<Type> types = new ArrayList<Type>();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            Collections.addAll(types, paramType.typeArguments());
        }
        return types;
    }

    protected Object renderType(Type type) {
        String returnTypeText = this.asText(type);
        String externalFile = this.asReference(type);
        if (this.fileCatalog.check(externalFile)) {
            returnTypeText = this.link(externalFile, new Object[]{returnTypeText});
        }
        for (Type paramType : this.getParametrizedTypes(type)) {
            this.fileCatalog.check(this.asReference(paramType));
        }
        return returnTypeText;
    }

    protected Tag[] getDeprecatedTags(Doc service) {
        return service.tags("deprecated");
    }

    protected Tag[] getTags(Doc service) {
        Tag[] deprecatedTags = this.getDeprecatedTags(service);
        Tag[] firstSentenceTags = service.firstSentenceTags();
        if (deprecatedTags.length > 0) {
            Tag[] tags = Arrays.copyOf(firstSentenceTags, firstSentenceTags.length + 1);
            tags[firstSentenceTags.length] = deprecatedTags[0];
            return tags;
        }
        return firstSentenceTags;
    }
}

