/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.xebialabs.gradle.documentation.restdoc.doclet.FileCatalog;
import com.xebialabs.gradle.documentation.restdoc.doclet.OverviewWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.PageTemplate;
import com.xebialabs.gradle.documentation.restdoc.doclet.Resource;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestServiceWriter;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocletUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RestDoclet {
    private static File destinationDir = new File(".");
    private static boolean showJsonSupport = true;
    private static String productName = null;
    private static String jsonOutputFile = "api.json";

    public static int optionLength(String option) {
        return 2;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        block12: for (String[] option : options) {
            switch (option[0]) {
                case "-d": {
                    destinationDir = new File(option[1]);
                    continue block12;
                }
                case "-showJsonSupport": {
                    showJsonSupport = Boolean.parseBoolean(option[1]);
                    continue block12;
                }
                case "-product": {
                    productName = option[1];
                    continue block12;
                }
                case "-jsonOutputFile": {
                    jsonOutputFile = option[1];
                }
            }
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static boolean start(RootDoc root) {
        List<ClassDoc> apiServices = DocletUtils.findAnnotatedClasses(root, "com.xebialabs.xlplatform.documentation.PublicApi");
        List<ClassDoc> apiRefs = DocletUtils.findAnnotatedClasses(root, "com.xebialabs.xlplatform.documentation.PublicApiRef");
        ArrayList allApiClasses = Lists.newArrayList(apiServices);
        allApiClasses.addAll(apiRefs);
        Preconditions.checkNotNull((Object)productName, (Object)"The productName should not be 'null', please specify '-product'");
        if (!apiServices.isEmpty()) {
            RestDoclet.copyCss();
            RestDoclet.writeOverview(apiServices);
            RestDoclet.writeServices(apiServices);
            RestDoclet.writeLinkedFiles();
        }
        RestDoclet.writeJsonFile(allApiClasses);
        return true;
    }

    private static void writeJsonFile(List<ClassDoc> restServices) {
        File destination = new File(destinationDir, jsonOutputFile);
        try (FileWriter fileWriter = new FileWriter(destination);){
            fileWriter.write(DocletUtils.generateJson(restServices));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void copyCss() {
        Resource.fromClasspath("restdoc/layout.css").copy(new File(destinationDir, "layout.css"));
        Resource.fromClasspath("restdoc/restdoc.css").copy(new File(destinationDir, "restdoc.css"));
        Resource.fromClasspath("restdoc/image.zip").unzip(destinationDir);
    }

    private static void writeOverview(List<ClassDoc> restServices) {
        PrintWriter writer = RestDoclet.openFile("index.html", String.format("%s REST API", productName));
        try {
            new OverviewWriter(writer, productName).write(restServices);
        }
        finally {
            RestDoclet.closeFile(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeServices(List<ClassDoc> restServices) {
        for (ClassDoc service : restServices) {
            FileCatalog.SINGLETON.add(RestDoclet.fileNameFor((Type)service));
        }
        for (ClassDoc service : restServices) {
            PrintWriter writer = RestDoclet.openFile(RestDoclet.fileNameFor((Type)service), service.name());
            try {
                new RestServiceWriter(writer, service, showJsonSupport).writeRestService();
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
    }

    private static void writeLinkedFiles() {
        for (String item : FileCatalog.SINGLETON.getItems()) {
            if (!FileCatalog.isResource(item)) continue;
            PrintWriter writer = RestDoclet.openFile(item, item.replace(".html", ""));
            try {
                FileCatalog.write(item, writer);
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
        for (String item : FileCatalog.SINGLETON.getMissing()) {
            System.out.println("Missing cross reference: " + item);
        }
    }

    public static String fileNameFor(Type service) {
        if (service == null) {
            return null;
        }
        return service.qualifiedTypeName() + ".html";
    }

    public static String fileNameFor(String reference) {
        if (reference == null) {
            return null;
        }
        return reference + ".html";
    }

    public static PrintWriter openFile(String fileName, String title) {
        File file = new File(destinationDir, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            new PageTemplate(writer).writeHeader(title);
            return writer;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Can't open " + file.getAbsolutePath() + " for writing.");
        }
    }

    public static void closeFile(PrintWriter writer) {
        new PageTemplate(writer).writeFooter();
        writer.flush();
        writer.close();
    }
}

