/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class Resource
extends ByteSource {
    static final int BUFFER = 2048;

    public void write(PrintWriter writer) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                writer.println(line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read resource " + this.getName(), e);
        }
    }

    public void unzip(File destinationDir) {
        try {
            destinationDir.mkdirs();
            try (ZipInputStream zis = new ZipInputStream(this.openBufferedStream());){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    this.unzipEntry(destinationDir, zis, entry);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unzipEntry(File destinationDir, ZipInputStream zis, ZipEntry entry) throws IOException {
        byte[] data = new byte[2048];
        File file = new File(destinationDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(file), 2048);){
                int count;
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    ((OutputStream)dest).write(data, 0, count);
                }
                ((OutputStream)dest).flush();
            }
        }
    }

    public void copy(File destination) {
        try {
            this.copyTo(Files.asByteSink((File)destination, (FileWriteMode[])new FileWriteMode[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public abstract InputStream openStream();

    public abstract String getName();

    public static Resource fromClasspath(final String name) {
        return new Resource(){

            @Override
            public InputStream openStream() {
                return Resource.class.getClassLoader().getResourceAsStream(name);
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static Resource file(final File file) {
        return new Resource(){

            @Override
            public InputStream openStream() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("Can't open " + this.getName(), e);
                }
            }

            @Override
            public String getName() {
                return file.getAbsolutePath();
            }
        };
    }
}

