/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Type;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDoclet;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestdocWriter;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;

public class OverviewWriter
extends RestdocWriter {
    private String productName;

    public OverviewWriter(PrintWriter writer, String productName) {
        super(writer);
        this.productName = productName;
    }

    public void write(List<ClassDoc> services) {
        this.writeHeader();
        this.writePackageInfo(services);
        this.writeServices(services);
    }

    private void writePackageInfo(List<ClassDoc> services) {
        LinkedHashSet<PackageDoc> packages = new LinkedHashSet<PackageDoc>();
        for (ClassDoc service : services) {
            packages.add(service.containingPackage());
        }
        for (PackageDoc pack : packages) {
            this.p(new Object[]{this.asText(pack.inlineTags())}).write();
        }
    }

    private void writeServices(List<ClassDoc> services) {
        this.table(new Object[0]).cssClass("services").writeOpen();
        for (ClassDoc service : services) {
            this.row(new Object[]{this.link(RestDoclet.fileNameFor((Type)service), new Object[]{service.name()}), this.asText(service.firstSentenceTags())}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    public void writeHeader() {
        this.div(new Object[]{this.h1(new Object[]{String.format("%s REST API", this.productName)})}).cssClass("manual-title").write();
    }
}

