package com.xebialabs.gradle.plugins

import com.xebialabs.gradle.plugins.tasks.PluginVersion
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.file.DuplicatesStrategy
import org.gradle.api.plugins.BasePlugin
import org.gradle.api.tasks.bundling.Zip

class XLPluginBundlePlugin implements Plugin<Project> {
  public static final String PLUGIN_VERSION_TASK_NAME = "createPluginVersionProperties"
  public static final String BUNDLING_TASK_NAME = "xlPlugin"

  @Override
  void apply(Project project) {
    addVersionPropertiesTask(project)
    setupDependencyBundling(project)
  }

  void addVersionPropertiesTask(Project project) {
    project.tasks.create(PLUGIN_VERSION_TASK_NAME, PluginVersion).configure {
      group = BasePlugin.BUILD_GROUP
      description = "Create a plugin-version.properties file with plugin metadata."
      dependsOn "processResources"
      conventionMapping.plugin = { -> project.name }
      conventionMapping.version = { -> project.version.toString() }
      String resourcesDir = project.sourceSets.main.output.resourcesDir.getAbsolutePath()
      pluginVersionFile = project.file("${resourcesDir}/plugin-version.properties")
    }

    project.tasks.getByName("jar").dependsOn(PLUGIN_VERSION_TASK_NAME)
  }

  static def setupDependencyBundling(Project project) {
    def distBundleConfig = project.configurations.maybeCreate("distBundle")

    def xlPluginTask = project.tasks.create(BUNDLING_TASK_NAME, Zip).configure {
      group = 'Archive'
      duplicatesStrategy = DuplicatesStrategy.EXCLUDE

      into(".") {
        from distBundleConfig
        from project.tasks.getByName("jar")
      }
    }

    project.artifacts {
      archives xlPluginTask
    }
  }
}
