package com.xebialabs.gradle.plugins.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

class PluginVersion extends DefaultTask {

  @Input
  String plugin

  @Input
  String version

  @OutputFile
  File pluginVersionFile

  @TaskAction
  public void addProperties() {
    pluginVersionFile.createNewFile()
    pluginVersionFile.withWriter { BufferedWriter w ->
      // Use the getters for the conventionMapping!
      w.writeLine("plugin=${getPlugin()}")
      w.writeLine("version=${getVersion()}")
    }
  }
}
