/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.deployit.documentation.MarkdownHtmlGenerator;
import com.xebialabs.deployit.documentation.RuntimeIOException;
import com.xebialabs.gradle.plugins.docgen.reference.ci.CiReferenceGenerator;
import com.xebialabs.gradle.plugins.docgen.reference.ci.TypeSystem;
import com.xebialabs.gradle.plugins.docgen.reference.step.StepDocumentationScanner;
import com.xebialabs.gradle.plugins.docgen.reference.step.StepReferenceGenerator;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGenerator
implements GroovyObject {
    @Option(usage="Url to the html snippet that is appended to the generated html document.", name="-htmlFooter")
    private URL htmlFooterSnippet;
    @Option(usage="Url to the html snippet that is added to the head tag in the generated html document.", name="-htmlHeader")
    private URL htmlHeaderSnippet;
    @Option(usage="Url to the web resource file(s)/zip(s) or local file(s)/folder(s) containing resources like images, css, etc.", name="-resource")
    private List<URL> resources;
    @Option(usage="Generate a single document from the multiple sources", name="-single")
    private boolean generateSingleDocument;
    @Option(usage="Markdown file(s) used as the source for document generation.", name="-source", required=true)
    private List<File> markdownSources;
    @Option(usage="Working directory to which documents are generated to.", name="-workingDir", required=true)
    private File workingDir;
    @Option(usage="\n      Properties used to customize the generation for individual documents.\n\n      Property name is a compound key, starting with the document file name without extension. eg. filePluginManual\n\n      'appendCiReference' : Specify if the document requires ci reference documentation append. eg. filePluginManual.appendCiReference=true.\n      'prefixes' : Comma separated string for which plugin namespaces get generated ci documentation.eg. filePluginManual.prefixes=file,udm.\n                   Omitted prefixes results in ci reference documentation for all types.\n       'title' : Tile of the documents as it appears on the pdf cover eg. filePluginManual.title=File Manual\n       'version' : Version of the plugin.\n\n       You can supply any other property you may need to replace during generation. You can use {{prop}} as the placeholder in your markdown.\n     ", name="-properties")
    private File propertiesSource;
    @Option(usage="Url to the html template that is to be used to generate the html document.", name="-htmlTemplate", required=true)
    private URL htmlTemplate;
    private ContextProperties properties;
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public DocumentGenerator() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        this.resources = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        this.markdownSources = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void main(String ... args) {
        CallSite documentGenerator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DocumentGenerator.class));
        CallSite parser = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CmdLineParser.class, documentGenerator));
        try {
            IndyInterface.bootstrap("invoke", "parseArgument", 0, parser, args);
            IndyInterface.bootstrap("invoke", "generate", 0, documentGenerator);
        }
        catch (CmdLineException e) {
            IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "err", 0, System.class), IndyInterface.bootstrap("invoke", "getMessage", 0, e));
            IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "err", 0, System.class), "java DocumentGenerator [options...] arguments...");
            IndyInterface.bootstrap("invoke", "printUsage", 0, parser, IndyInterface.bootstrap("getProperty", "err", 0, System.class));
            IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "err", 0, System.class));
            IndyInterface.bootstrap("invoke", "exit", 0, System.class, true);
        }
    }

    private void generate() {
        IndyInterface.bootstrap("invoke", "downloadResourcesToWorkingDir", 2, this);
        IndyInterface.bootstrap("invoke", "generateHtmlFromMarkdownSources", 2, this);
    }

    private void downloadResourcesToWorkingDir() {
        CallSite resource = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, this.resources));
        if (callSite != null) {
            while (callSite.hasNext()) {
                resource = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite filename = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractFileName", 0, IOUtils.class, resource));
                CallSite ext = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractFileNameExtension", 0, IOUtils.class, filename));
                IndyInterface.bootstrap("invoke", "info", 0, logger, "Processing resource '{}'. Resource has a file name of '{}' with extension '{}'.", resource, filename, ext);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, "zip", ext)) != false) {
                    IndyInterface.bootstrap("invoke", "copyUncompressed", 2, this, resource, filename);
                    continue;
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, "", ext)) != false) {
                    IndyInterface.bootstrap("invoke", "copyLocalFolder", 2, this, resource, filename);
                    continue;
                }
                IndyInterface.bootstrap("invoke", "copy", 0, IOUtils.class, resource, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.workingDir, filename));
            }
        }
    }

    private void copyUncompressed(URL resource, String filename) {
        CallSite archive = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.workingDir, filename));
        IndyInterface.bootstrap("invoke", "copy", 0, IOUtils.class, resource, archive);
        IndyInterface.bootstrap("invoke", "explodeArchive", 0, IOUtils.class, archive, this.workingDir);
        IndyInterface.bootstrap("invoke", "delete", 0, archive);
    }

    private void copyLocalFolder(URL resource, String folder) {
        CallSite sourceFolder = null;
        try {
            sourceFolder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "toURI", 0, resource)));
        }
        catch (URISyntaxException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, e));
        }
        IndyInterface.bootstrap("invoke", "copyDirectory", 0, IOUtils.class, sourceFolder, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.workingDir, folder));
    }

    private List<File> generateHtmlFromMarkdownSources() {
        CallSite htmlFiles = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        if (this.generateSingleDocument) {
            IndyInterface.bootstrap("invoke", "add", 0, htmlFiles, IndyInterface.bootstrap("invoke", "generateSinglePageHtml", 2, this));
        } else {
            htmlFiles = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "generateMultiplePageHtml", 2, this));
        }
        return htmlFiles;
    }

    private File generateSinglePageHtml() {
        CallSite singleDocument = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.workingDir, "singleDocument.html"));
        String config = "singleDocument";
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Creating single html document '{}' from markdown sources '{}'.", IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, singleDocument), IndyInterface.bootstrap("invoke", "getMainMarkdownFiles", 2, this));
        CallSite out = null;
        try {
            try {
                CallSite header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHeader", 2, this, config));
                CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBody", 2, this, config));
                CallSite footer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getFooter", 2, this, config));
                CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTemplate", 2, this));
                out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PrintWriter.class, IndyInterface.bootstrap("init", "<init>", 0, FileWriter.class, singleDocument)));
                IndyInterface.bootstrap("invoke", "writeDocument", 2, this, out, config, template, header, body, footer);
            }
            catch (IOException e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, e));
            }
        }
        finally {
            IndyInterface.bootstrap("invoke", "closeQuietly", 0, Closeables.class, out);
        }
        return singleDocument;
    }

    private String getTemplate() {
        Object result = "";
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.htmlTemplate, null)) {
            result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getText", 0, IOUtils.class, this.htmlTemplate));
        }
        return result;
    }

    private String getBody(String config) {
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        CallSite out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PrintWriter.class, sw));
        CallSite markdownSource = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "getMainMarkdownFiles", 2, this)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                markdownSource = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "generateHtmlBodyFromMarkdownSource", 2, this, markdownSource, out, config);
            }
        }
        IndyInterface.bootstrap("invoke", "finalizeBody", 2, this, out, config);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
    }

    private String getBody(String config, File markdownSource) {
        CallSite sw = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringWriter.class));
        CallSite out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PrintWriter.class, sw));
        IndyInterface.bootstrap("invoke", "generateHtmlBodyFromMarkdownSource", 2, this, markdownSource, out, config);
        IndyInterface.bootstrap("invoke", "finalizeBody", 2, this, out, config);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, sw));
    }

    private String getFooter(String config) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSnippetWithPlaceholderReplacementOrBlank", 2, this, this.htmlFooterSnippet, config));
    }

    private String getHeader(String config) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSnippetWithPlaceholderReplacementOrBlank", 2, this, this.htmlHeaderSnippet, config));
    }

    private String getSnippetWithPlaceholderReplacementOrBlank(URL snippet, String config) {
        if (ScriptBytecodeAdapter.compareEqual((Object)snippet, null)) {
            return "";
        }
        CallSite ctx = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootContextMergedWithConfig", 2, this, config));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replacePlaceholders", 0, IOUtils.class, IndyInterface.bootstrap("invoke", "getText", 0, IOUtils.class, snippet), ctx));
    }

    private void writeDocument(PrintWriter out, String config, String template, String header, String body, String footer) {
        CallSite ctx = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootContextMergedWithConfig", 2, this, config));
        IndyInterface.bootstrap("invoke", "put", 0, ctx, "header", header);
        IndyInterface.bootstrap("invoke", "put", 0, ctx, "body", body);
        IndyInterface.bootstrap("invoke", "put", 0, ctx, "footer", footer);
        IndyInterface.bootstrap("invoke", "println", 0, out, IndyInterface.bootstrap("invoke", "replacePlaceholders", 0, IOUtils.class, template, ctx));
    }

    private List<File> generateMultiplePageHtml() {
        CallSite markdownFiles = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMainMarkdownFiles", 2, this));
        IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "out", 0, System.class), IndyInterface.bootstrap("invoke", "plus", 0, "!!!markdownFiles, ", IndyInterface.bootstrap("invoke", "toString", 0, markdownFiles)));
        IndyInterface.bootstrap("invoke", "info", 0, logger, "Creating multiple html documents from markdown sources '{}'.", markdownFiles);
        CallSite generatedFiles = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        CallSite markdownSource = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, markdownFiles));
        if (callSite != null) {
            while (callSite.hasNext()) {
                markdownSource = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite config = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractFileNameWithoutExtension", 0, IOUtils.class, markdownSource));
                CallSite htmlFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createFileNameWithNewExtension", 0, IOUtils.class, markdownSource, this.workingDir, "html"));
                IndyInterface.bootstrap("invoke", "info", 0, logger, "Creating html document '{}' from markdown source '{}'.", IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, htmlFile), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, markdownSource));
                CallSite out = null;
                try {
                    try {
                        CallSite header = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHeader", 2, this, config));
                        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBody", 2, this, config, markdownSource));
                        CallSite footer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getFooter", 2, this, config));
                        CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTemplate", 2, this));
                        out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PrintWriter.class, IndyInterface.bootstrap("init", "<init>", 0, FileWriter.class, htmlFile)));
                        IndyInterface.bootstrap("invoke", "writeDocument", 2, this, out, config, template, header, body, footer);
                        IndyInterface.bootstrap("invoke", "add", 0, generatedFiles, htmlFile);
                    }
                    catch (IOException e) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeIOException.class, e));
                    }
                }
                finally {
                    IndyInterface.bootstrap("invoke", "closeQuietly", 0, Closeables.class, out);
                }
            }
        }
        return generatedFiles;
    }

    private List<File> getMainMarkdownFiles() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMarkdownFilesWithPredicate", 2, this, IndyInterface.bootstrap("invoke", "not", 0, Predicates.class, IndyInterface.bootstrap("init", "<init>", 0, StepMarkdownFile.class))));
    }

    private List<File> getMarkdownFilesWithPredicate(Predicate<File> predicate) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newArrayList", 0, Lists.class, IndyInterface.bootstrap("invoke", "filter", 0, Iterables.class, this.markdownSources, predicate)));
    }

    protected PrintWriter initializeHead(PrintWriter out) {
        return out;
    }

    protected void finalizeBody(PrintWriter out, String config) {
        CallSite ctx = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootContextMergedWithConfig", 2, this, config));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, "true", IndyInterface.bootstrap("invoke", "get", 0, ctx, "appendCiReference"))) != false) {
            CallSite prefixes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "emptyList", 0, Collections.class));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "get", 0, ctx, "prefixes"), null)) {
                CallSite split = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "trimResults", 0, IndyInterface.bootstrap("invoke", "on", 0, Splitter.class, ",")), IndyInterface.bootstrap("invoke", "get", 0, ctx, "prefixes")));
                prefixes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newArrayList", 0, Lists.class, split));
            }
            CallSite cis = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findDescriptorsForPrefixes", 0, TypeSystem.class, prefixes));
            IndyInterface.bootstrap("invoke", "generateCiReference", 0, CiReferenceGenerator.class, cis, "cireference/ci-reference.tpl", out);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, "true", IndyInterface.bootstrap("invoke", "get", 0, ctx, "appendStepReference"))) != false) {
            CallSite stepPackage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, ctx, "stepPackage"));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)stepPackage, null)) {
                CallSite markdownSources = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMarkdownFilesWithPredicate", 2, this, IndyInterface.bootstrap("init", "<init>", 0, StepMarkdownFile.class)));
                CallSite contextProperties = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootContextMergedWithConfig", 2, this, config));
                CallSite stepDocumentation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findStepDocumentation", 0, StepDocumentationScanner.class, stepPackage, markdownSources));
                IndyInterface.bootstrap("invoke", "generateStepReference", 0, StepReferenceGenerator.class, stepDocumentation, contextProperties, "stepreference/step-reference.tpl", out);
            }
        }
    }

    private void generateHtmlBodyFromMarkdownSource(File markdownSource, PrintWriter out, String config) {
        CallSite markdownHtmlGenerator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, MarkdownHtmlGenerator.class, markdownSource, IndyInterface.bootstrap("invoke", "getRootContextMergedWithConfig", 2, this, config)));
        IndyInterface.bootstrap("invoke", "generate", 0, markdownHtmlGenerator, out);
    }

    private ContextProperties getRootContextMergedWithConfig(String config) {
        CallSite ctx = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRootContext", 0, IndyInterface.bootstrap("invoke", "getProperties", 2, this)));
        IndyInterface.bootstrap("invoke", "putAll", 0, ctx, IndyInterface.bootstrap("invoke", "getContext", 0, IndyInterface.bootstrap("invoke", "getProperties", 2, this), config));
        return ctx;
    }

    private ContextProperties getProperties() {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.properties), null)) {
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ContextProperties.class);
            this.properties = IndyInterface.bootstrap("cast", "()", 0, callSite);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.propertiesSource, null)) {
                try {
                    CallSite temp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Properties.class));
                    IndyInterface.bootstrap("invoke", "load", 0, temp, IndyInterface.bootstrap("init", "<init>", 0, FileInputStream.class, this.propertiesSource));
                    CallSite key = null;
                    CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "stringPropertyNames", 0, temp)));
                    if (callSite2 != null) {
                        while (callSite2.hasNext()) {
                            key = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                            IndyInterface.bootstrap("invoke", "put", 0, this.properties, key, IndyInterface.bootstrap("invoke", "getProperty", 0, temp, key));
                        }
                    }
                }
                catch (IOException e) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeIOException.class, e));
                }
            }
        }
        return this.properties;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DocumentGenerator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DocumentGenerator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DocumentGenerator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DocumentGenerator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DocumentGenerator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DocumentGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, DocumentGenerator.class);
        logger = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    private static class StepMarkdownFile
    implements Predicate<File>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public StepMarkdownFile() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean apply(File input) {
            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "getName", 0, input), "step-"));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), StepMarkdownFile.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DocumentGenerator.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DocumentGenerator.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), StepMarkdownFile.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(StepMarkdownFile.class, DocumentGenerator.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(StepMarkdownFile.class, DocumentGenerator.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), StepMarkdownFile.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StepMarkdownFile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

