package com.xebialabs.gradle.plugins.docgen.reference.step

import com.xebialabs.deployit.documentation.ContextProperties
import com.xebialabs.gradle.plugins.docgen.reference.step.model.Step
import groovy.text.Template
import groovy.text.markup.MarkupTemplateEngine

import static com.xebialabs.gradle.plugins.docgen.reference.MarkupTemplateEngineConfiguration.engineConfiguration

class StepReferenceGenerator {

  static void generateStepReference(List<Step> steps, ContextProperties contextProperties, String templateName, Writer out) {
    MarkupTemplateEngine engine = new MarkupTemplateEngine(engineConfiguration())

    def model = ['steps': steps, contextProperties: contextProperties]
    def modelTypes = new HashMap<String, String>();
    modelTypes.put("steps", "List<${Step.class.canonicalName}>");
    modelTypes.put("contextProperties", ContextProperties.class.canonicalName);

    Template template = engine.createTypeCheckedModelTemplateByPath(templateName, modelTypes)

    Writable output = template.make(model)
    //output.writeTo(new OutputStreamWriter(System.out))
    output.writeTo(out)
  }
}
