package com.xebialabs.gradle.plugins.docgen.reference.ci

import com.xebialabs.deployit.plugin.api.reflect.Descriptor
import groovy.text.Template
import groovy.text.markup.MarkupTemplateEngine

import static com.xebialabs.gradle.plugins.docgen.reference.MarkupTemplateEngineConfiguration.engineConfiguration

class CiReferenceGenerator {

  static void generateCiReference(List<Descriptor> cis, String templateName, Writer out) {
    MarkupTemplateEngine engine = new MarkupTemplateEngine(engineConfiguration())

    def model = ['cis': cis]
    def modelTypes = new HashMap<String, String>();
    modelTypes.put("cis", "List<${Descriptor.class.canonicalName}>");

    Template template = engine.createTypeCheckedModelTemplateByPath(templateName, modelTypes)

    Writable output = template.make(model)
    //output.writeTo(new OutputStreamWriter(System.out))
    output.writeTo(out)
  }
}
