/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import com.xebialabs.deployit.documentation.MarkdownHtmlGenerator;
import com.xebialabs.deployit.documentation.RuntimeIOException;
import com.xebialabs.gradle.plugins.docgen.reference.ci.CiReferenceGenerator;
import com.xebialabs.gradle.plugins.docgen.reference.ci.TypeSystem;
import com.xebialabs.gradle.plugins.docgen.reference.step.StepDocumentationScanner;
import com.xebialabs.gradle.plugins.docgen.reference.step.StepReferenceGenerator;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGenerator
implements GroovyObject {
    @Option(usage="Url to the html snippet that is appended to the generated html document.", name="-htmlFooter")
    private URL htmlFooterSnippet;
    @Option(usage="Url to the html snippet that is added to the head tag in the generated html document.", name="-htmlHeader")
    private URL htmlHeaderSnippet;
    @Option(usage="Url to the web resource file(s)/zip(s) or local file(s)/folder(s) containing resources like images, css, etc.", name="-resource")
    private List<URL> resources;
    @Option(usage="Generate a single document from the multiple sources", name="-single")
    private boolean generateSingleDocument;
    @Option(usage="Markdown file(s) used as the source for document generation.", name="-source", required=true)
    private List<File> markdownSources;
    @Option(usage="Working directory to which documents are generated to.", name="-workingDir", required=true)
    private File workingDir;
    @Option(usage="\n      Properties used to customize the generation for individual documents.\n\n      Property name is a compound key, starting with the document file name without extension. eg. filePluginManual\n\n      'appendCiReference' : Specify if the document requires ci reference documentation append. eg. filePluginManual.appendCiReference=true.\n      'prefixes' : Comma separated string for which plugin namespaces get generated ci documentation.eg. filePluginManual.prefixes=file,udm.\n                   Omitted prefixes results in ci reference documentation for all types.\n       'title' : Tile of the documents as it appears on the pdf cover eg. filePluginManual.title=File Manual\n       'version' : Version of the plugin.\n\n       You can supply any other property you may need to replace during generation. You can use {{prop}} as the placeholder in your markdown.\n     ", name="-properties")
    private File propertiesSource;
    @Option(usage="Url to the html template that is to be used to generate the html document.", name="-htmlTemplate", required=true)
    private URL htmlTemplate;
    private ContextProperties properties;
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DocumentGenerator() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(ArrayList.class);
        this.resources = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[1].callConstructor(ArrayList.class);
        this.markdownSources = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        DocumentGenerator documentGenerator = (DocumentGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(DocumentGenerator.class), DocumentGenerator.class);
        CmdLineParser parser = (CmdLineParser)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(CmdLineParser.class, (Object)documentGenerator), CmdLineParser.class);
        try {
            callSiteArray[4].call((Object)parser, (Object)args);
            callSiteArray[5].call((Object)documentGenerator);
        }
        catch (CmdLineException e) {
            callSiteArray[6].call(callSiteArray[7].callGetProperty(System.class), callSiteArray[8].call((Object)e));
            callSiteArray[9].call(callSiteArray[10].callGetProperty(System.class), (Object)"java DocumentGenerator [options...] arguments...");
            callSiteArray[11].call((Object)parser, callSiteArray[12].callGetProperty(System.class));
            callSiteArray[13].call(callSiteArray[14].callGetProperty(System.class));
            callSiteArray[15].call(System.class, (Object)1);
        }
    }

    private void generate() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[16].callCurrent((GroovyObject)this);
            callSiteArray[17].callCurrent((GroovyObject)this);
        } else {
            this.downloadResourcesToWorkingDir();
            this.generateHtmlFromMarkdownSources();
        }
    }

    private void downloadResourcesToWorkingDir() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        URL resource = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(this.resources), Iterator.class);
        while (iterator.hasNext()) {
            resource = (URL)ScriptBytecodeAdapter.castToType(iterator.next(), URL.class);
            String filename = ShortTypeHandling.castToString((Object)callSiteArray[19].callStatic(IOUtils.class, (Object)resource));
            String ext = ShortTypeHandling.castToString((Object)callSiteArray[20].callStatic(IOUtils.class, (Object)filename));
            callSiteArray[21].call((Object)logger, (Object)"Processing resource '{}'. Resource has a file name of '{}' with extension '{}'.", (Object)resource, (Object)filename, (Object)ext);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)"zip", (Object)ext))) {
                callSiteArray[23].callCurrent((GroovyObject)this, (Object)resource, (Object)filename);
                continue;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)"", (Object)ext))) {
                callSiteArray[25].callCurrent((GroovyObject)this, (Object)resource, (Object)filename);
                continue;
            }
            callSiteArray[26].callStatic(IOUtils.class, (Object)resource, callSiteArray[27].callConstructor(File.class, (Object)this.workingDir, (Object)filename));
        }
    }

    private void copyUncompressed(URL resource, String filename) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        File archive = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callConstructor(File.class, (Object)this.workingDir, (Object)filename), File.class);
        callSiteArray[29].callStatic(IOUtils.class, (Object)resource, (Object)archive);
        callSiteArray[30].callStatic(IOUtils.class, (Object)archive, (Object)this.workingDir);
        callSiteArray[31].call((Object)archive);
    }

    private void copyLocalFolder(URL resource, String folder) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        File sourceFolder = null;
        try {
            Object object = callSiteArray[32].callConstructor(File.class, callSiteArray[33].call((Object)resource));
            sourceFolder = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        }
        catch (URISyntaxException e) {
            throw (Throwable)callSiteArray[34].callConstructor(RuntimeException.class, (Object)e);
        }
        callSiteArray[35].callStatic(IOUtils.class, (Object)sourceFolder, callSiteArray[36].callConstructor(File.class, (Object)this.workingDir, (Object)folder));
    }

    private List<File> generateHtmlFromMarkdownSources() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        List htmlFiles = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(ArrayList.class), List.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (this.generateSingleDocument) {
                callSiteArray[38].call(htmlFiles, callSiteArray[39].callCurrent((GroovyObject)this));
            } else {
                Object object = callSiteArray[40].callCurrent((GroovyObject)this);
                htmlFiles = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            }
        } else if (this.generateSingleDocument) {
            callSiteArray[41].call(htmlFiles, (Object)this.generateSinglePageHtml());
        } else {
            List list;
            htmlFiles = list = this.generateMultiplePageHtml();
        }
        return htmlFiles;
    }

    private File generateSinglePageHtml() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        File singleDocument = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callConstructor(File.class, (Object)this.workingDir, (Object)"singleDocument.html"), File.class);
        String config = "singleDocument";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[43].call((Object)logger, (Object)"Creating single html document '{}' from markdown sources '{}'.", callSiteArray[44].call((Object)singleDocument), callSiteArray[45].callCurrent((GroovyObject)this));
        } else {
            callSiteArray[46].call((Object)logger, (Object)"Creating single html document '{}' from markdown sources '{}'.", callSiteArray[47].call((Object)singleDocument), this.getMainMarkdownFiles());
        }
        PrintWriter out = null;
        try {
            try {
                String header = null;
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[48].callCurrent((GroovyObject)this, (Object)config);
                    header = ShortTypeHandling.castToString((Object)object);
                } else {
                    String string;
                    header = string = this.getHeader(config);
                }
                String body = null;
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[49].callCurrent((GroovyObject)this, (Object)config);
                    body = ShortTypeHandling.castToString((Object)object);
                } else {
                    String string;
                    body = string = this.getBody(config);
                }
                String footer = null;
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[50].callCurrent((GroovyObject)this, (Object)config);
                    footer = ShortTypeHandling.castToString((Object)object);
                } else {
                    String string;
                    footer = string = this.getFooter(config);
                }
                String template = null;
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[51].callCurrent((GroovyObject)this);
                    template = ShortTypeHandling.castToString((Object)object);
                } else {
                    String string;
                    template = string = this.getTemplate();
                }
                Object object = callSiteArray[52].callConstructor(PrintWriter.class, callSiteArray[53].callConstructor(FileWriter.class, (Object)singleDocument));
                out = (PrintWriter)ScriptBytecodeAdapter.castToType((Object)object, PrintWriter.class);
                callSiteArray[54].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)out, (Object)config, (Object)template, (Object)header, (Object)body, (Object)footer));
            }
            catch (IOException e) {
                throw (Throwable)callSiteArray[55].callConstructor(RuntimeException.class, (Object)e);
            }
        }
        catch (Throwable throwable) {
            callSiteArray[57].callStatic(Closeables.class, out);
            throw throwable;
        }
        callSiteArray[56].callStatic(Closeables.class, (Object)out);
        return singleDocument;
    }

    private String getTemplate() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        String result = "";
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.htmlTemplate, null)) {
            Object object = callSiteArray[58].callStatic(IOUtils.class, (Object)this.htmlTemplate);
            result = ShortTypeHandling.castToString((Object)object);
        }
        return result;
    }

    private String getBody(String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(StringWriter.class), StringWriter.class);
        PrintWriter out = (PrintWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(PrintWriter.class, (Object)sw), PrintWriter.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            File markdownSource = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].call(callSiteArray[62].callCurrent((GroovyObject)this)), Iterator.class);
            while (iterator.hasNext()) {
                markdownSource = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                callSiteArray[63].callCurrent((GroovyObject)this, (Object)markdownSource, (Object)out, (Object)config);
            }
        } else {
            File markdownSource = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(this.getMainMarkdownFiles()), Iterator.class);
            while (iterator.hasNext()) {
                markdownSource = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                callSiteArray[65].callCurrent((GroovyObject)this, (Object)markdownSource, (Object)out, (Object)config);
            }
        }
        callSiteArray[66].callCurrent((GroovyObject)this, (Object)out, (Object)config);
        return ShortTypeHandling.castToString((Object)callSiteArray[67].call((Object)sw));
    }

    private String getBody(String config, File markdownSource) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        StringWriter sw = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(StringWriter.class), StringWriter.class);
        PrintWriter out = (PrintWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(PrintWriter.class, (Object)sw), PrintWriter.class);
        callSiteArray[70].callCurrent((GroovyObject)this, (Object)markdownSource, (Object)out, (Object)config);
        callSiteArray[71].callCurrent((GroovyObject)this, (Object)out, (Object)config);
        return ShortTypeHandling.castToString((Object)callSiteArray[72].call((Object)sw));
    }

    private String getFooter(String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[73].callCurrent((GroovyObject)this, (Object)this.htmlFooterSnippet, (Object)config));
        }
        return this.getSnippetWithPlaceholderReplacementOrBlank(this.htmlFooterSnippet, config);
    }

    private String getHeader(String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[74].callCurrent((GroovyObject)this, (Object)this.htmlHeaderSnippet, (Object)config));
        }
        return this.getSnippetWithPlaceholderReplacementOrBlank(this.htmlHeaderSnippet, config);
    }

    private String getSnippetWithPlaceholderReplacementOrBlank(URL snippet, String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)snippet, null)) {
            return "";
        }
        ContextProperties ctx = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[75].callCurrent((GroovyObject)this, (Object)config);
            ctx = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
        } else {
            ContextProperties contextProperties;
            ctx = contextProperties = this.getRootContextMergedWithConfig(config);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[76].callStatic(IOUtils.class, callSiteArray[77].callStatic(IOUtils.class, (Object)snippet), (Object)ctx));
    }

    private void writeDocument(PrintWriter out, String config, String template, String header, String body, String footer) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        ContextProperties ctx = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[78].callCurrent((GroovyObject)this, (Object)config);
            ctx = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
        } else {
            ContextProperties contextProperties;
            ctx = contextProperties = this.getRootContextMergedWithConfig(config);
        }
        callSiteArray[79].call((Object)ctx, (Object)"header", (Object)header);
        callSiteArray[80].call((Object)ctx, (Object)"body", (Object)body);
        callSiteArray[81].call((Object)ctx, (Object)"footer", (Object)footer);
        callSiteArray[82].call((Object)out, callSiteArray[83].callStatic(IOUtils.class, (Object)template, (Object)ctx));
    }

    private List<File> generateMultiplePageHtml() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        List markdownFiles = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[84].callCurrent((GroovyObject)this);
            markdownFiles = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            List list;
            markdownFiles = list = this.getMainMarkdownFiles();
        }
        callSiteArray[85].call(callSiteArray[86].callGetProperty(System.class), callSiteArray[87].call((Object)"!!!markdownFiles, ", callSiteArray[88].call((Object)markdownFiles)));
        callSiteArray[89].call((Object)logger, (Object)"Creating multiple html documents from markdown sources '{}'.", (Object)markdownFiles);
        List generatedFiles = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].callConstructor(ArrayList.class), List.class);
        File markdownSource = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)markdownFiles), Iterator.class);
        while (iterator.hasNext()) {
            markdownSource = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
            String config = ShortTypeHandling.castToString((Object)callSiteArray[92].callStatic(IOUtils.class, (Object)markdownSource));
            File htmlFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callStatic(IOUtils.class, (Object)markdownSource, (Object)this.workingDir, (Object)"html"), File.class);
            callSiteArray[94].call((Object)logger, (Object)"Creating html document '{}' from markdown source '{}'.", callSiteArray[95].call((Object)htmlFile), callSiteArray[96].call((Object)markdownSource));
            PrintWriter out = null;
            try {
                try {
                    String header = ShortTypeHandling.castToString((Object)callSiteArray[97].callCurrent((GroovyObject)this, (Object)config));
                    String body = ShortTypeHandling.castToString((Object)callSiteArray[98].callCurrent((GroovyObject)this, (Object)config, (Object)markdownSource));
                    String footer = ShortTypeHandling.castToString((Object)callSiteArray[99].callCurrent((GroovyObject)this, (Object)config));
                    String template = ShortTypeHandling.castToString((Object)callSiteArray[100].callCurrent((GroovyObject)this));
                    Object object = callSiteArray[101].callConstructor(PrintWriter.class, callSiteArray[102].callConstructor(FileWriter.class, (Object)htmlFile));
                    out = (PrintWriter)ScriptBytecodeAdapter.castToType((Object)object, PrintWriter.class);
                    callSiteArray[103].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)out, (Object)config, (Object)template, (Object)header, (Object)body, (Object)footer));
                    callSiteArray[104].call((Object)generatedFiles, (Object)htmlFile);
                }
                catch (IOException e) {
                    throw (Throwable)callSiteArray[105].callConstructor(RuntimeIOException.class, (Object)e);
                }
            }
            catch (Throwable throwable) {
                callSiteArray[107].callStatic(Closeables.class, out);
                throw throwable;
            }
            callSiteArray[106].callStatic(Closeables.class, (Object)out);
        }
        return generatedFiles;
    }

    private List<File> getMainMarkdownFiles() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].callCurrent((GroovyObject)this, callSiteArray[109].callStatic(Predicates.class, callSiteArray[110].callConstructor(StepMarkdownFile.class))), List.class);
    }

    private List<File> getMarkdownFilesWithPredicate(Predicate<File> predicate) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].callStatic(Lists.class, callSiteArray[112].call(Iterables.class, this.markdownSources, predicate)), List.class);
    }

    protected PrintWriter initializeHead(PrintWriter out) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        return out;
    }

    protected void finalizeBody(PrintWriter out, String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        ContextProperties ctx = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[113].callCurrent((GroovyObject)this, (Object)config);
            ctx = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
        } else {
            ContextProperties contextProperties;
            ctx = contextProperties = this.getRootContextMergedWithConfig(config);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[114].call((Object)"true", callSiteArray[115].call((Object)ctx, (Object)"appendCiReference")))) {
            List prefixes = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].call(Collections.class), List.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[117].call((Object)ctx, (Object)"prefixes"), null)) {
                Iterable split = (Iterable)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call(callSiteArray[119].call(callSiteArray[120].call(Splitter.class, (Object)",")), callSiteArray[121].call((Object)ctx, (Object)"prefixes")), Iterable.class);
                Object object = callSiteArray[122].callStatic(Lists.class, (Object)split);
                prefixes = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            }
            List cis = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call(TypeSystem.class, (Object)prefixes), List.class);
            callSiteArray[124].callStatic(CiReferenceGenerator.class, (Object)cis, (Object)"cireference/ci-reference.tpl", (Object)out);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[125].call((Object)"true", callSiteArray[126].call((Object)ctx, (Object)"appendStepReference")))) {
            String stepPackage = ShortTypeHandling.castToString((Object)callSiteArray[127].call((Object)ctx, (Object)"stepPackage"));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)stepPackage, null)) {
                List markdownSources = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callCurrent((GroovyObject)this, callSiteArray[129].callConstructor(StepMarkdownFile.class)), List.class);
                ContextProperties contextProperties = null;
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[130].callCurrent((GroovyObject)this, (Object)config);
                    contextProperties = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
                } else {
                    ContextProperties contextProperties2;
                    contextProperties = contextProperties2 = this.getRootContextMergedWithConfig(config);
                }
                List stepDocumentation = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].callStatic(StepDocumentationScanner.class, (Object)stepPackage, (Object)markdownSources), List.class);
                callSiteArray[132].callStatic(StepReferenceGenerator.class, (Object)stepDocumentation, (Object)contextProperties, (Object)"stepreference/step-reference.tpl", (Object)out);
            }
        }
    }

    private void generateHtmlBodyFromMarkdownSource(File markdownSource, PrintWriter out, String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        MarkdownHtmlGenerator markdownHtmlGenerator = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[133].callConstructor(MarkdownHtmlGenerator.class, (Object)markdownSource, callSiteArray[134].callCurrent((GroovyObject)this, (Object)config));
            markdownHtmlGenerator = (MarkdownHtmlGenerator)ScriptBytecodeAdapter.castToType((Object)object, MarkdownHtmlGenerator.class);
        } else {
            Object object = callSiteArray[135].callConstructor(MarkdownHtmlGenerator.class, (Object)markdownSource, (Object)this.getRootContextMergedWithConfig(config));
            markdownHtmlGenerator = (MarkdownHtmlGenerator)ScriptBytecodeAdapter.castToType((Object)object, MarkdownHtmlGenerator.class);
        }
        callSiteArray[136].call((Object)markdownHtmlGenerator, (Object)out);
    }

    private ContextProperties getRootContextMergedWithConfig(String config) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        ContextProperties ctx = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[137].call(callSiteArray[138].callCurrent((GroovyObject)this));
            ctx = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
        } else {
            Object object = callSiteArray[139].call((Object)this.getProperties());
            ctx = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[140].call((Object)ctx, callSiteArray[141].call(callSiteArray[142].callCurrent((GroovyObject)this), (Object)config));
        } else {
            callSiteArray[143].call((Object)ctx, callSiteArray[144].call((Object)this.getProperties(), (Object)config));
        }
        return ctx;
    }

    private ContextProperties getProperties() {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.properties), null)) {
            Object object = callSiteArray[145].callConstructor(ContextProperties.class);
            this.properties = (ContextProperties)((Object)ScriptBytecodeAdapter.castToType((Object)object, ContextProperties.class));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.propertiesSource, null)) {
                try {
                    Properties temp = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].callConstructor(Properties.class), Properties.class);
                    callSiteArray[147].call((Object)temp, callSiteArray[148].callConstructor(FileInputStream.class, (Object)this.propertiesSource));
                    String key = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].call(callSiteArray[150].call((Object)temp)), Iterator.class);
                    while (iterator.hasNext()) {
                        key = ShortTypeHandling.castToString(iterator.next());
                        callSiteArray[151].call((Object)this.properties, (Object)key, callSiteArray[152].call((Object)temp, (Object)key));
                    }
                }
                catch (IOException e) {
                    throw (Throwable)callSiteArray[153].callConstructor(RuntimeIOException.class, (Object)e);
                }
            }
        }
        return this.properties;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DocumentGenerator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DocumentGenerator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DocumentGenerator.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DocumentGenerator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DocumentGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = DocumentGenerator.$getCallSiteArray()[154].call(LoggerFactory.class, DocumentGenerator.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "parseArgument";
        stringArray[5] = "generate";
        stringArray[6] = "println";
        stringArray[7] = "err";
        stringArray[8] = "getMessage";
        stringArray[9] = "println";
        stringArray[10] = "err";
        stringArray[11] = "printUsage";
        stringArray[12] = "err";
        stringArray[13] = "println";
        stringArray[14] = "err";
        stringArray[15] = "exit";
        stringArray[16] = "downloadResourcesToWorkingDir";
        stringArray[17] = "generateHtmlFromMarkdownSources";
        stringArray[18] = "iterator";
        stringArray[19] = "extractFileName";
        stringArray[20] = "extractFileNameExtension";
        stringArray[21] = "info";
        stringArray[22] = "equals";
        stringArray[23] = "copyUncompressed";
        stringArray[24] = "equals";
        stringArray[25] = "copyLocalFolder";
        stringArray[26] = "copy";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "copy";
        stringArray[30] = "explodeArchive";
        stringArray[31] = "delete";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "toURI";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "copyDirectory";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "add";
        stringArray[39] = "generateSinglePageHtml";
        stringArray[40] = "generateMultiplePageHtml";
        stringArray[41] = "add";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "info";
        stringArray[44] = "getAbsolutePath";
        stringArray[45] = "getMainMarkdownFiles";
        stringArray[46] = "info";
        stringArray[47] = "getAbsolutePath";
        stringArray[48] = "getHeader";
        stringArray[49] = "getBody";
        stringArray[50] = "getFooter";
        stringArray[51] = "getTemplate";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "writeDocument";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "closeQuietly";
        stringArray[57] = "closeQuietly";
        stringArray[58] = "getText";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "iterator";
        stringArray[62] = "getMainMarkdownFiles";
        stringArray[63] = "generateHtmlBodyFromMarkdownSource";
        stringArray[64] = "iterator";
        stringArray[65] = "generateHtmlBodyFromMarkdownSource";
        stringArray[66] = "finalizeBody";
        stringArray[67] = "toString";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "generateHtmlBodyFromMarkdownSource";
        stringArray[71] = "finalizeBody";
        stringArray[72] = "toString";
        stringArray[73] = "getSnippetWithPlaceholderReplacementOrBlank";
        stringArray[74] = "getSnippetWithPlaceholderReplacementOrBlank";
        stringArray[75] = "getRootContextMergedWithConfig";
        stringArray[76] = "replacePlaceholders";
        stringArray[77] = "getText";
        stringArray[78] = "getRootContextMergedWithConfig";
        stringArray[79] = "put";
        stringArray[80] = "put";
        stringArray[81] = "put";
        stringArray[82] = "println";
        stringArray[83] = "replacePlaceholders";
        stringArray[84] = "getMainMarkdownFiles";
        stringArray[85] = "println";
        stringArray[86] = "out";
        stringArray[87] = "plus";
        stringArray[88] = "toString";
        stringArray[89] = "info";
        stringArray[90] = "<$constructor$>";
        stringArray[91] = "iterator";
        stringArray[92] = "extractFileNameWithoutExtension";
        stringArray[93] = "createFileNameWithNewExtension";
        stringArray[94] = "info";
        stringArray[95] = "getAbsolutePath";
        stringArray[96] = "getAbsolutePath";
        stringArray[97] = "getHeader";
        stringArray[98] = "getBody";
        stringArray[99] = "getFooter";
        stringArray[100] = "getTemplate";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "writeDocument";
        stringArray[104] = "add";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "closeQuietly";
        stringArray[107] = "closeQuietly";
        stringArray[108] = "getMarkdownFilesWithPredicate";
        stringArray[109] = "not";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "newArrayList";
        stringArray[112] = "filter";
        stringArray[113] = "getRootContextMergedWithConfig";
        stringArray[114] = "equals";
        stringArray[115] = "get";
        stringArray[116] = "emptyList";
        stringArray[117] = "get";
        stringArray[118] = "split";
        stringArray[119] = "trimResults";
        stringArray[120] = "on";
        stringArray[121] = "get";
        stringArray[122] = "newArrayList";
        stringArray[123] = "findDescriptorsForPrefixes";
        stringArray[124] = "generateCiReference";
        stringArray[125] = "equals";
        stringArray[126] = "get";
        stringArray[127] = "get";
        stringArray[128] = "getMarkdownFilesWithPredicate";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "getRootContextMergedWithConfig";
        stringArray[131] = "findStepDocumentation";
        stringArray[132] = "generateStepReference";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "getRootContextMergedWithConfig";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "generate";
        stringArray[137] = "getRootContext";
        stringArray[138] = "getProperties";
        stringArray[139] = "getRootContext";
        stringArray[140] = "putAll";
        stringArray[141] = "getContext";
        stringArray[142] = "getProperties";
        stringArray[143] = "putAll";
        stringArray[144] = "getContext";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "<$constructor$>";
        stringArray[147] = "load";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "iterator";
        stringArray[150] = "stringPropertyNames";
        stringArray[151] = "put";
        stringArray[152] = "getProperty";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[155];
        DocumentGenerator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DocumentGenerator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DocumentGenerator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static class StepMarkdownFile
    implements Predicate<File>,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public StepMarkdownFile() {
            MetaClass metaClass;
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean apply(File input) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call((Object)input), (Object)"step-"));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StepMarkdownFile.class, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StepMarkdownFile.class, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = StepMarkdownFile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StepMarkdownFile.class, DocumentGenerator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StepMarkdownFile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "startsWith";
            stringArray[1] = "getName";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            StepMarkdownFile.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(StepMarkdownFile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = StepMarkdownFile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

