package cireference

import com.xebialabs.deployit.plugin.api.reflect.Descriptor

// define incoming model, so type checking works
modelTypes = {
  String category
  List<Descriptor> cis
}

static String extractFirstSentence(String text) {
  switch(text) {
    case null:
      ""; break
    case text.indexOf(".") > -1:
      text.substring(0, text.indexOf(".")); break
    default: text
  }
}

if (cis) {
  h4(category, class: 'ci-toc-category')
  newLine()

  table(class: 'ci-toc') {
    tr(class: 'odd ci-toc-header') {
      th('CI')
      th('Description')
    }
    newLine()

    cis.eachWithIndex { Descriptor ci, int idx ->
      tr(class: idx % 2 ? 'odd' : 'even') {
        if (ci.isVirtual())
          td { a(ci.type, href: "#${ci.type}", class: 'virtual-type') }
        else
          td { a(ci.type, href: "#${ci.type}") }
        newLine()
        td(extractFirstSentence(ci.description == 'null (deployable)' ? "" : ci.description))
      }
      newLine()
    }
  }
}
