import com.xebialabs.deployit.documentation.ContextProperties
import com.xebialabs.deployit.documentation.MarkdownHtmlGenerator
import com.xebialabs.gradle.plugins.docgen.reference.step.model.Parameter
import com.xebialabs.gradle.plugins.docgen.reference.step.model.Step

def markdownFileToHtml(File markdown, ContextProperties contextProperties) {
  def out = new StringWriter()
  new MarkdownHtmlGenerator(markdown, contextProperties).generate(out)
  out.toString()
}

if (steps) {
  div(class: "ci-reference") {
    h2('Step Reference', class: "ci-toc-category")
    steps.eachWithIndex { Step step, int i ->

      h3(step.name, class: "ci-toc-category")
      yieldUnescaped markdownFileToHtml(step.markdownDescription, contextProperties)
      h4('Step Parameters', class: "ci-toc-category")
      table(class: "ci-toc", summary: 'Step Parameters') {
        tr(class: "odd ci-toc-header") {
          th('Parameter')
          th('Type')
          th('Description')
          th('Required')
          th('Calculated')
        }
        step.parameters.eachWithIndex { Parameter parameter, int idx ->
          tr(class: idx % 2 ? 'odd' : 'even') {
            td(parameter.name)
            td(parameter.type)
            td(parameter.description)
            td(parameter.required ? "Yes" : "No")
            td(parameter.calculated ? "Yes" : "No")
          }
        }
      }
      strong('Note: ')
      yield 'For information about how values are calculated, refer to '
      a('Use a predefined step in a rule', href: "/xl-deploy/how-to/use-a-predefined-step-in-a-rule.html")
      yield '.'
    }
  }
}
