package com.xebialabs.gradle.plugins.docgen.tasks

import org.gradle.api.Project

class GenerateDocumentationExtension {

  String htmlTemplate

  String htmlHeader

  String htmlFooter

  /**
   * A way to configure version variable in the documentation. If it is {@code null} then {@code $project.version} will be taken.
   */
  String version = null

  List<String> docResources

  ConfigObject config = new ConfigObject()

  def docClasspath = new LinkedHashSet<File>()

  void usingProject(Project project) {
    htmlTemplate = "htmlTemplate.html"
    htmlHeader = "htmlHeader.html"
    htmlFooter = "htmlFooter.html"
    docResources = ["css/deployit.css", "css/ci-reference-api.css", "css/layout.css", "image.zip", "js.zip"]
  }
}
