package com.xebialabs.gradle.plugins.docgen.reference.ci

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.plugin.api.reflect.Descriptor
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry
import org.slf4j.Logger
import org.slf4j.LoggerFactory

class TypeSystem {
  private static final Logger logger = LoggerFactory.getLogger(TypeSystem);

  static {
    if (logger.isDebugEnabled()) {
      ClassLoader cl = ClassLoader.getSystemClassLoader();

      URL[] urls = ((URLClassLoader) cl).getURLs();

      logger.debug("Starting local booter with classpath:")
      for (URL url : urls) {
        logger.debug("local booter classpath: {}", url.getFile())
      }
    }
    LocalBooter.bootWithoutGlobalContext();
  }

  public static List<Descriptor> findDescriptorsForPrefixes(List<String> prefixes) {
    def filtered = DescriptorRegistry.getDescriptors().findAll({ descriptor ->
      descriptor.getDescription() && (prefixes.isEmpty() || descriptor.getType().getPrefix() in prefixes)
    }).sort(false, { o1, o2 -> (o1.getType().toString() <=> o2.getType().toString()) })

    logger.info("Found {} CI descriptors to generate documentation for.", filtered.size());

    return filtered;
  }
}
