package cireference

import com.xebialabs.deployit.plugin.api.reflect.*
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.Container
import com.xebialabs.deployit.plugin.api.udm.Deployable
import com.xebialabs.deployit.plugin.api.udm.Deployed

def typesInDocument = cis.collect({ Descriptor it -> it.type }) as Set
def deployables = cis.findAll({ it.isAssignableTo(Deployable.class) })
def deployeds = cis.findAll({ it.isAssignableTo(Deployed.class) })
def containers = cis.findAll({ it.isAssignableTo(Container.class) })
def others = cis.findAll({
  !(it.isAssignableTo(Deployable.class) || it.isAssignableTo(Deployed.class) || it.isAssignableTo(Container.class))
})

def sortByRequiredAndName = { PropertyDescriptor o1, PropertyDescriptor o2 ->
  int result = o1.isRequired() == o2.isRequired() ? 0 : (o1.isRequired() ? -1 : 1);
  if (result == 0) {
    result = o1.getName() <=> o2.getName();
  }
  result;
}

def sortTypeByName = { Type t1, Type t2 -> t1.name <=> t2.name }

boolean isParent(PropertyDescriptor ci) {
  return ci.isAsContainment() && ci.getKind() == PropertyKind.CI
}

boolean isChild(PropertyDescriptor ci) {
  return ci.isAsContainment() && ci.getKind() != PropertyKind.CI
}

div(class: 'ci-reference') {
  // toc-header
  h2('CI Reference', class: 'ci-toc-category')
  newLine()
  h3('Configuration Item Overview', class: 'ci-details-title')
  newLine()
  // /toc-header

  layout 'cireference/ci-toc.tpl', category: 'Deployables', cis: deployables
  newLine()

  layout 'cireference/ci-toc.tpl', category: 'Deployeds', cis: deployeds
  newLine()

  layout 'cireference/ci-toc.tpl', category: 'Containers', cis: containers
  newLine()

  layout 'cireference/ci-toc.tpl', category: 'Other Configuration Items', cis: others
  newLine()

  h3('Configuration Item Details', class: 'ci-details-title')
  cis.each { Descriptor ci ->
    newLine()
    a('', id: ci.type)
    newLine()
    h4(ci.type, class: 'ci-detail-title')

    if (ci.superClasses) {
      newLine()
      table(class: 'ci-relations-table', summary: "CI relations") {
        if (ci.virtual) {
          tr {
            th('Virtual Type', colspan: '2')
          }
        }
        if (ci.superClasses.size() > 1) {
          tr {
            th('Type&nbsp;Hierarchy')
            td {
              def separator = ''
              ci.superClasses.each { Type type ->
                yield separator
                if (type in typesInDocument)
                  a(type, href: "#${type}")
                else
                  yield type
                separator = ' >> '
              }
            }
          }
        }
        List<Type> interfaces = ci.interfaces.findAll({ it != Type.valueOf(ConfigurationItem.class) }).sort(false, sortTypeByName)
        if (interfaces) {
          newLine()
          tr {
            th('Interfaces')
            td {
              def separator = ''
              interfaces.each { Type type ->
                yield separator
                if (type in typesInDocument)
                  a(type, href: "#${type}")
                else
                  yield type
                separator = ', '
              }
            }
          }
        }
      }

      newLine()
      p("${ci.description == 'null (deployable)' ? "" : ci.description}", class: 'ci-description')

      List<PropertyDescriptor> properties = ci.propertyDescriptors.sort(false, sortByRequiredAndName)
      def parentProperties = properties.findAll { isParent(it) && !it.isHidden() }
      def childProperties = properties.findAll { isChild(it) && !it.isHidden() }
      def publicProperties = properties.findAll { !it.isHidden() && !isParent(it) && !isChild(it) }
      def hiddenProperties = properties.findAll { it.isHidden() }

      layout 'cireference/ci-properties.tpl', category: 'Parent', properties: parentProperties, typesInDocument: typesInDocument
      newLine()

      layout 'cireference/ci-properties.tpl', category: 'Children', properties: childProperties, typesInDocument: typesInDocument
      newLine()

      layout 'cireference/ci-properties.tpl', category: 'Public properties', properties: publicProperties, typesInDocument: typesInDocument
      newLine()

      layout 'cireference/ci-properties.tpl', category: 'Hidden properties', properties: hiddenProperties, typesInDocument: typesInDocument
      newLine()

      layout 'cireference/ci-controltasks.tpl', controlTasks: ci.controlTasks.sort(false, { MethodDescriptor o1, MethodDescriptor o2 -> o1.name <=> o2.name })

      hr()
    }
  }
}
