package com.xebialabs.deployit.documentation

import com.vladsch.flexmark.html.HtmlRenderer
import com.vladsch.flexmark.parser.Parser
import com.vladsch.flexmark.util.options.DataHolder
import com.vladsch.flexmark.util.options.MutableDataSet

import static com.xebialabs.deployit.documentation.IOUtils.getTextWithInclusions
import static com.xebialabs.deployit.documentation.IOUtils.replacePlaceholders

class MarkdownHtmlGenerator {

  private final File markdownFile;
  private final ContextProperties contextProperties;
  private final DataHolder options = new MutableDataSet(); // PegdownOptionsAdapter.flexmarkOptions(Extensions.ALL);
  private final Parser parser = Parser.builder(options).build();
  private final HtmlRenderer renderer = HtmlRenderer.builder(options).build();

  public MarkdownHtmlGenerator(final File markdownFile, ContextProperties contextProperties) {
    this.markdownFile = markdownFile;
    this.contextProperties = contextProperties;
  }

  public void generate(final Writer writer) {
    try {
      String markdownText = getTextWithInclusions(markdownFile);
      markdownText = replacePlaceholders(markdownText, contextProperties);
      String html = renderer.render(parser.parse(markdownText));
      writer.write(html);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
}
