package cireference

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.plugin.api.reflect.Type

// define incoming model, so type checking works
modelTypes = {
  String category
  List<PropertyDescriptor> properties
  Set<Type> typesInDocument
}

if (properties) {
  newLine()
  table(class: 'ci-table', summary: category) {
    tr(class: 'odd ci-prop-header') {
      th('&nbsp;')
      th('&nbsp;')
      th(category)
    }
    newLine()

    properties.eachWithIndex { PropertyDescriptor property, int idx ->
      def rowStyle = idx % 2 ? 'odd' : 'even'
      tr(class: rowStyle) {
        td(class: 'icon-cell') {
          if (property.isInspectionProperty()) {
            if (property.isRequiredForInspection()) {
              div('&nbsp;', class: 'icon inspection-required', title: 'Inspection property (required)')
            } else {
              div('&nbsp;', class: 'icon inspection', title: 'Inspection property')
            }
          } else {
            div('&nbsp;', class: 'icon')
          }
        }
        td(class: 'icon-cell') {
          if (property.isRequired())
            div('&nbsp;', class: 'icon required', title: 'Required property')
          else
            div('&nbsp;', class: 'icon')
        }
        td(style: 'width: 100%') {
          div(class: 'ci-property-info') {
            span(property.name, class: 'ci-property-name')
            span(': ')
            if (property.kind == PropertyKind.ENUM)
              span("${property.kind} ${property.enumValues.toArray()}", class: 'ci-property-kind')
            else if (property.kind in [PropertyKind.CI, PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI]) {
              span(class: 'ci-property-kind') {
                yield "${property.kind}<"
                if (property.referencedType in typesInDocument)
                  a(property.referencedType, href: "#${property.referencedType}")
                else
                  yield property.referencedType
                yield ">"
              }
            } else
              span(property.kind, class: 'ci-property-kind')
            if (property.defaultValue) {
              yieldUnescaped '&nbsp;=&nbsp;'
              if (property.kind == PropertyKind.MAP_STRING_STRING) {
                Map<String, String> defaultValue = property.defaultValue as Map
                span("{ ${defaultValue.collect({ k, v -> "${k}=${v}" }).join(', ')} }", class: 'ci-property-default')
              } else
                span(property.defaultValue.toString(), class: 'ci-property-default')
            }
          }
        }
      }
      tr(class: rowStyle) {
        td()
        td()
        td {
          div(property.description, class: 'ci-property-desc')
        }
      }
    }
  }
}
