package cireference

import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor

// define incoming model, so type checking works
modelTypes = {
  List<MethodDescriptor> controlTasks
}

if (controlTasks) {
  table(class: 'ci-properties', summary: 'Control tasks') {
    tr(class: 'odd ci-prop-header') {
      th('Control task')
      th('Parameter CI')
      th('Attributes')
      th('Description')
    }
    newLine()

    controlTasks.eachWithIndex { MethodDescriptor method, int idx ->
      tr(class: idx % 2 ? 'odd' : 'even') {
        td {
          span(method.name, class: 'ci-property-name')
        }
        td {
          if (method.parameterObjectType)
            a(method.parameterObjectType.toString(), href: "#${method.parameterObjectType}")
          else
            yield ""
        }
        td {
          def attributes = method.attributes.collect({ k, v -> "${k} = ${v}" }).join(', ')
          if(attributes) {
            p(attributes)
          }
        }
        td {
          p(method.description, class: 'ci-property-desc')
        }
      }
      newLine()
    }
  }
}
