/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class MarkdownHtmlGenerator {
    private final File markdownFile;
    private final ContextProperties contextProperties;
    private final DataHolder options = new MutableDataSet();
    private final Parser parser = Parser.builder((DataHolder)this.options).build();
    private final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)this.options).build();

    public MarkdownHtmlGenerator(File markdownFile, ContextProperties contextProperties) {
        this.markdownFile = markdownFile;
        this.contextProperties = contextProperties;
    }

    public void generate(Writer writer) {
        try {
            String markdownText = IOUtils.getTextWithInclusions(this.markdownFile);
            markdownText = IOUtils.replacePlaceholders(markdownText, this.contextProperties);
            String html = this.renderer.render((Node)this.parser.parse(markdownText));
            writer.write(html);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

