/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.documentation.html.Element;
import com.xebialabs.deployit.documentation.html.HtmlWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CiReferenceHtmlWriter
extends HtmlWriter {
    private Set<Type> typesInDocument = new HashSet<Type>();

    public CiReferenceHtmlWriter(PrintWriter writer) {
        super(writer);
    }

    public void startCiReference() {
        this.div(new Object[0]).cssClass("ci-reference").writeOpen();
    }

    public void endCiReference() {
        this.div(new Object[0]).writeClose();
    }

    public void tocHeader() {
        this.h2("CI Reference").cssClass("ci-toc-category").write();
        this.h3("Configuration Item Overview").cssClass("ci-details-title").write();
    }

    public void startToc() {
        this.table(new Object[0]).cssClass("ci-toc").writeOpen();
        this.rowHeader("CI", "Description").cssClass("odd ci-toc-header").write();
    }

    public void endToc() {
        this.table(new Object[0]).writeClose();
    }

    public void tocEntry(Descriptor ci, String firstSentence, int row) {
        Element type = this.link("#" + ci.getType(), ci.getType());
        if (ci.isVirtual()) {
            type = type.cssClass("virtual-type");
        }
        this.row(type, firstSentence).cssClass(row % 2 == 0 ? "even" : "odd").write();
    }

    public void detailsHeader() {
        this.h3("Configuration Item Details").cssClass("ci-details-title").write();
    }

    public void detailsSeparator() {
        this.hr().write();
    }

    public void ciDescription(String description) {
        this.p(description).cssClass("ci-description").write();
    }

    public void ciDetailTitle(Type type) {
        this.anchor(type.toString(), new Object[0]).write();
        this.h4(type).cssClass("ci-detail-title").write();
    }

    public void ciTypeInfo(Descriptor ci) {
        if (ci.getSuperClasses().isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("ci-relations-table");
        if (ci.isVirtual()) {
            table.add(this.tr(this.th("Virtual Type").attribute("colspan", "2")));
        }
        if (ci.getSuperClasses().size() > 1) {
            table.add(this.generateTypeRow(ci.getSuperClasses(), "Type&nbsp;Hierarchy", " >> "));
        }
        LinkedHashSet interfaces = new LinkedHashSet(ci.getInterfaces());
        interfaces.remove(Type.valueOf(ConfigurationItem.class));
        if (!ci.getInterfaces().isEmpty()) {
            table.add(this.generateTypeRow(ci.getInterfaces(), "Interfaces", ", "));
        }
        table.write();
    }

    private Element generateTypeRow(Collection<Type> types, String header, String separator) {
        Element row = this.rowHeader(header);
        Element cell = this.td(new Object[0]);
        row.add(cell);
        int i = 0;
        for (Type type : types) {
            cell.add(this.render(type));
            if (++i >= types.size()) continue;
            cell.add(separator);
        }
        return row;
    }

    private String render(Type type) {
        if (this.typesInDocument.contains(type)) {
            return this.link("#" + type.toString(), type).toString();
        }
        return type.toString();
    }

    public void ciProperties(Collection<PropertyDescriptor> properties, String category) {
        if (properties.isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("ci-table");
        table.add(this.rowHeader("", "", category).cssClass("odd ci-prop-header"));
        int row = 0;
        for (PropertyDescriptor property : properties) {
            String css = row % 2 == 0 ? "even" : "odd";
            table.add(this.getPropertyInfoRow(property).cssClass(css));
            table.add(this.getPropertyDescriptionRow(property).cssClass(css));
            ++row;
        }
        table.write();
    }

    private Element getPropertyInfoRow(PropertyDescriptor descriptor) {
        Element row = this.tr(new Object[0]);
        row.add(this.td(this.getInspectionIcon(descriptor)).cssClass("icon-cell"));
        row.add(this.td(this.getRequiredIcon(descriptor)).cssClass("icon-cell"));
        Element cell = this.div(new Object[0]).cssClass("ci-property-info");
        row.add(this.td(cell).attribute("style", "width: 100%"));
        cell.add(this.span(descriptor.getName()).cssClass("ci-property-name"));
        cell.add(this.span(": "));
        Element kind = this.span(descriptor.getKind()).cssClass("ci-property-kind");
        cell.add(kind);
        if (descriptor.getKind() == PropertyKind.ENUM) {
            kind.add(" ", Arrays.toString(descriptor.getEnumValues().toArray()));
        }
        if (descriptor.getKind() == PropertyKind.CI || descriptor.getKind() == PropertyKind.SET_OF_CI || descriptor.getKind() == PropertyKind.LIST_OF_CI) {
            kind.add("&lt;", this.render(descriptor.getReferencedType()), "&gt;");
        }
        if (descriptor.getDefaultValue() != null) {
            cell.add("&nbsp;=&nbsp;");
            cell.add(this.span(descriptor.getDefaultValue()).cssClass("ci-property-default"));
        }
        return row;
    }

    private Element getRequiredIcon(PropertyDescriptor descriptor) {
        Element icon = this.div("&nbsp;").cssClass("icon");
        if (descriptor.isRequired()) {
            icon.cssClass("icon required").attribute("title", "Required property");
        }
        return icon;
    }

    private Element getInspectionIcon(PropertyDescriptor descriptor) {
        Element icon = this.div("&nbsp;").cssClass("icon");
        if (descriptor.isInspectionProperty()) {
            if (descriptor.isRequiredForInspection()) {
                icon.cssClass("icon inspection-required").attribute("title", "Inspection property (required)");
            } else {
                icon.cssClass("icon inspection").attribute("title", "Inspection property");
            }
        }
        return icon;
    }

    private Element getPropertyDescriptionRow(PropertyDescriptor descriptor) {
        return this.row("", "", this.div(descriptor.getDescription()).cssClass("ci-property-desc"));
    }

    public void startControlTask(String category) {
        this.table(new Object[0]).cssClass("ci-properties").writeOpen();
        this.rowHeader("Control task", "Parameter CI", "Attributes", "Description").cssClass("odd ci-prop-header").write();
    }

    public void endControlTask() {
        this.table(new Object[0]).writeClose();
    }

    public void controlTaskMethod(MethodDescriptor method, int row) {
        Type type = method.getParameterObjectType();
        this.row(this.span(method.getName()).cssClass("ci-property-name"), type == null ? "" : this.link("#" + type.toString(), type.toString()), this.p(this.listAttributes(method)), this.p(method.getDescription()).cssClass("ci-property-desc")).cssClass(row % 2 == 0 ? "even" : "odd").write();
    }

    private String listAttributes(MethodDescriptor method) {
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        return joiner.join(Iterables.transform(method.getAttributes().entrySet(), (Function)new Function<Map.Entry<String, String>, Object>(){

            public Object apply(Map.Entry<String, String> input) {
                return input.getKey() + " = " + input.getValue();
            }
        }));
    }

    public void categoryHeader(String category) {
        this.h4(category).cssClass("ci-toc-category").write();
    }

    public void setCis(List<Descriptor> cis) {
        this.typesInDocument = Sets.newLinkedHashSet();
        for (Descriptor ci : cis) {
            this.typesInDocument.add(ci.getType());
        }
    }

    public void startDocument() {
        this.html(new Object[0]).writeOpen();
        this.head(this.title("CI Reference"), this.linkCss("deployit.css"), this.linkCss("ci-reference-api.css")).write();
        this.body(new Object[0]).writeOpen();
    }

    public void endDocument() {
        this.body(new Object[0]).writeClose();
        this.html(new Object[0]).writeClose();
    }
}

