package ai.digital.gradle.defaults

import org.gradle.api.Plugin
import org.gradle.api.Project

class BasePlugin implements Plugin<Project> {
  void apply(Project project) {
    project.plugins.apply('digitalai.idea')

    if (!project.hasProperty('offline')) {
      project.repositories {
        if (project.hasProperty('nexusBaseUrl')) {
          maven {
            url = "${project.property('nexusBaseUrl')}/groups/public"
          }
          ['alphas', 'releases', 'thirdparty', 'hidden-thirdparty'].each { repositoryName ->
            maven {
              credentials {
                username = project.property('nexusUserName')
                password = project.property('nexusPassword')
              }
              url = "${project.property('nexusBaseUrl')}/repositories/$repositoryName"
            }
          }
        }

        if (project.hasProperty('localMavenRepository')) {
          maven {
            url "${project.rootDir.toURI().toURL()}mavenrepo/snapshots"
          }
          maven {
            url "${project.rootDir.toURI().toURL()}mavenrepo/releases"
          }
        }

        mavenLocal()
      }
    }
  }
}
