package ai.digital.gradle.defaults.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction
import org.gradle.process.ExecOperations
import javax.inject.Inject

abstract class NebulaPublishRelease extends DefaultTask {

  @Input
  String version

  @Inject
  abstract ExecOperations getExecOperations()

  NebulaPublishRelease() {
    this.mustRunAfter("clean")
  }

  @TaskAction
  void doRelease() {
    def version = "${getVersion()}-${(new Date().format('Mdd.Hmm'))}".toString()
    project.logger.lifecycle("Releasing version is: $version")

    getExecOperations().exec {
      executable = './gradlew'
      args = [
        'build', 'publish',
        "-Prelease.version=${version}",
        '-x', 'test', 'final', '-x', 'releaseCheck', '-x', 'checkDependencyVersions'
      ]
    }
  }
}
