package ai.digital.gradle.defaults.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.provider.Provider
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

class DumpVersion extends DefaultTask {

  DumpVersion() {
    this.mustRunAfter("clean")
  }

  @OutputFile
  File dumpFile

  // keep this flexible: caller may pass a String or a Provider<String>
  @Input
  Object version

  @TaskAction
  def dump() {
    // resolve provider if needed
    def resolved = (version instanceof Provider) ? version.get() : (version != null ? version.toString() : project.version.toString())

    logger.lifecycle("Dumping version ${resolved} to file.")
    if (!dumpFile.parentFile.isDirectory()) {
      dumpFile.parentFile.mkdirs()
    }
    dumpFile.write("version=${resolved}\n")
  }
}
