package ai.digital.gradle.defaults

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.scala.ScalaCompile

class ScalaPlugin implements Plugin<Project> {
  void apply(Project project) {
    project.plugins.apply('digitalai.java')
    project.plugins.apply('scala')

    project.dependencies {
      api 'org.scala-lang:scala-library'
    }

    project.sourceSets {
      main {
        scala {
          srcDirs = ["src/main/java", "src/main/scala"]
        }
        java {
          srcDirs = []
        }
      }
      test {
        scala {
          srcDirs = ["src/test/java", "src/test/scala"]
        }
        java {
          srcDirs = []
        }
      }
    }

    project.tasks.withType(ScalaCompile) {
      options.encoding = "UTF-8"
      scalaCompileOptions.with {
        encoding = "UTF-8"
        force = true
        forkOptions.with {
          memoryMaximumSize = '1g'
          memoryInitialSize = '512m'
        }
        additionalParameters = [
          "-feature",
          "-Wunused:imports",
          "-Wconf:cat=other-match-analysis:w,cat=unused-imports:e,cat=feature-implicit-conversions:e"
        ]
      }
    }
  }
}
