package ai.digital.gradle.artifact

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.TaskContainer
import org.gradle.api.tasks.bundling.Jar

class PublicArtifactPlugin implements Plugin<Project> {
  void apply(Project project) {
    project.plugins.apply('com.github.hierynomus.license')

    project.license {
      header project.file('HEADER')
      ignoreFailures false
      strictCheck true
      exclude '**/*.json'
    }

    TaskContainer tasks = project.tasks
    tasks.withType(Jar) { task ->
      task.from(project.rootProject.file('LEGAL_NOTICE'))
    }
  }
}
