package ai.digital.gradle.artifact

import org.gradle.api.Plugin
import org.gradle.api.Project

class ArtifactPlugin implements Plugin<Project> {

  void apply(Project project) {
    project.plugins.apply('maven-publish')

    project.tasks.register("uploadArchives") {
      group "upload"
      if (project.hasProperty("localMavenRepository")) {
        dependsOn "publishAllPublicationsToMavenRepoRepository"
      } else {
        dependsOn "publishAllPublicationsToXebialabsRepository"
      }
    }

    project.tasks.register("uploadArchivesToBuildRepo") {
      group "upload"
      dependsOn "publishAllPublicationsToRepoRepository"
    }

    project.tasks.register("uploadArchivesToLocalMavenRepository") {
      group "upload"
      dependsOn "publishAllPublicationsToMavenRepoRepository"
    }

    project.tasks.register("uploadArchivesToMavenLocal") {
      group "upload"
      dependsOn "publishToMavenLocal"
    }

    def repositoryName = project.version.toString().endsWith('-SNAPSHOT') ? "snapshots" : "releases"

    project.publishing {
      repositories {
        maven {
          name 'repo'
          url = project.layout.buildDirectory.dir("repo").get().asFile.toURI().toURL()
        }
        maven {
          name 'mavenRepo'
          url = "${project.rootProject.rootDir.toURI().toURL()}mavenrepo/${repositoryName}"
        }
        maven {
          name 'xebialabs'
          url = "${project.property("nexusBaseUrl")}/repositories/${repositoryName}"
          credentials {
            username project.property("nexusUserName").toString()
            password project.property("nexusPassword").toString()
          }
        }
      }
    }
  }
}
