package ai.digital.gradle.plugins

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.Task
import org.gradle.api.plugins.JavaBasePlugin
import org.gradle.api.plugins.JavaPlugin
import org.gradle.api.tasks.testing.Test

class ITestPlugin implements Plugin<Project> {
  @Override
  void apply(Project project) {
    project.plugins.withType(JavaPlugin) {
      excludeItests(project)

      setupItestTask(project)
    }
  }

  private def setupItestTask(Project project) {
    project.tasks.create("itest", Test).configure {
      group = JavaBasePlugin.VERIFICATION_GROUP
      description = "Run the integration tests."
      includes = ["**/*Itest.*", "**/*ItestSuite.*"]
      reports.junitXml.destination = project.file("${project.buildDir}/itest-results")
      doFirst {
        ["itests", "testconfig", "testimage", "aws.endpoint", "aws.accessKey", "aws.secretKey"].each { p ->
          if (project.hasProperty(p)) {
            systemProperties[p] = project.getProperty(p)
          }
        }
      }
    }
  }

  private Task excludeItests(Project project) {
    project.tasks.withType(Test).getByName("test").configure {
      excludes = ["**/*Itest.*", "**/*ItestSuite.*"]
    }
  }
}
