package com.xebialabs.gradle.artifact

import nl.javadude.gradle.plugins.license.LicenseExtension
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.plugins.JavaPlugin
import org.gradle.jvm.tasks.Jar

class XLPublicArtifactPlugin implements Plugin<Project> {
  @Override
  void apply(Project project) {
    project.pluginManager.apply("com.github.hierynomus.license")
    project.pluginManager.apply("xebialabs.sources")
    project.pluginManager.apply("xebialabs.artifact")

    project.extensions.getByType(LicenseExtension).with {
      header = project.rootProject.file('HEADER')
      ignoreFailures = false
      strictCheck = true
      exclude '**/*.json'
    }

    project.tasks.withType(Jar) { t ->
      t.from(project.rootProject.file("LEGAL_NOTICE"))
    }

    project.plugins.withType(JavaPlugin) {
      ArtifactConfigurer.createJavaDocJarTask(project)
    }
  }
}
