package com.xebialabs.gradle.defaults.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.GradleException
import org.gradle.api.JavaVersion
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction

class CheckJavaVersion extends DefaultTask {

  @Input
  def targetCompatibility

  @TaskAction
  def checkVersion() {
    def javaVersion = System.properties['java.version']
    if (JavaVersion.toVersion(javaVersion) != JavaVersion.toVersion(targetCompatibility)) {
      throw new GradleException("Expected Java version ${targetCompatibility} but running with $javaVersion")
    }
  }
}
