package com.xebialabs.gradle.defaults

import com.xebialabs.gradle.defaults.tasks.CheckJavaVersion
import org.gradle.api.GradleException
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.language.base.plugins.LifecycleBasePlugin

class XLRootOpinionsPlugin implements Plugin<Project> {

  private Project project

  @Override
  void apply(Project project) {
    this.project = project

    project.apply plugin: RootOpinionsPlugin
    addCheckLanguageLevelTask()
  }

  private void addCheckLanguageLevelTask() {
    if (!project.hasProperty("languageLevel")) {
      throw new GradleException("Could not determine the Java language level, please add `languageLevel=(1.8|11)` to ${project.projectDir}/gradle.properties")
    }

    project.rootProject.tasks.create("checkJavaVersion", CheckJavaVersion).configure {
      group = LifecycleBasePlugin.VERIFICATION_GROUP
      description = "Check whether the Java version equals the required compatibility level"
      targetCompatibility = project.property("languageLevel")
    }
  }
}
