package com.xebialabs.gradle.artifact

import org.gradle.api.JavaVersion
import org.gradle.api.Project
import org.gradle.api.plugins.BasePlugin
import org.gradle.api.tasks.bundling.Jar
import org.gradle.api.tasks.javadoc.Javadoc

class ArtifactConfigurer {

  static def createSourceJarTask(Project project) {
    def task = project.tasks.create("sourcesJar", Jar.class).configure {
      group = BasePlugin.BUILD_GROUP
      description = "Assemble a jar archive containing the source files."
      from project.sourceSets.main.allSource
      classifier = "sources"
    }

    project.artifacts {
      archives task
    }

  }

  static def createJavaDocJarTask(Project project) {
    def task = project.tasks.create("javadocJar", org.gradle.jvm.tasks.Jar).configure {
      group = BasePlugin.BUILD_GROUP
      description = "Assemble a jar archive containing the javadoc documentation."
      dependsOn("javadoc")
      from project.tasks["javadoc"].destinationDir
      classifier = "javadoc"
    }

    project.tasks.withType(Javadoc) {
      options.encoding = 'UTF-8'
      options.charSet = 'UTF-8'
      if (JavaVersion.current().isJava8Compatible()) {
        options.addStringOption('Xdoclint:none', '-quiet')
      }
    }

    project.artifacts {
      archives task
    }
  }
}
