package com.xebialabs.gradle.defaults.tasks

import org.gradle.api.Action
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction
import org.gradle.process.ExecSpec

class NebulaRelease extends DefaultTask {

  NebulaRelease() {
    this.mustRunAfter("clean")
  }

  @Input
  String version

  @TaskAction
  void doRelease() {
    getProject().exec(new Action<ExecSpec>() {
      @Override
      void execute(ExecSpec execSpec) {
        def version = "${getVersion()}-${(new Date().format('Mdd.Hmm'))}".toString()
        project.logger.lifecycle("Releasing version is: $version")

        execSpec.executable('./gradlew')
        execSpec.args('build', 'uploadArchives',
          "-Prelease.version=${version}",
          '-x', 'test', 'final', '-x', 'releaseCheck', '-x', 'checkDependencyVersions')
      }
    })
  }
}
