/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.v3;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.test.v3.DummyContainer;
import com.xebialabs.deployit.plugin.test.v3.DummyJeeCluster;
import com.xebialabs.deployit.plugin.test.v3.DummyJeeQueue;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, inspectable=true)
public class DummyHost
extends DummyContainer {
    @Property
    @InspectionProperty(required=true)
    private String address;
    @Property
    private String os;
    @Property
    private String accessMethod;
    @Property
    @InspectionProperty(required=true)
    private String username;
    @Property
    @InspectionProperty(required=true)
    private String password;
    @Property(description="Servers in the node", asContainment=true, required=false)
    private Set<DummyContainer> servers = Sets.newHashSet();

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getAccessMethod() {
        return this.accessMethod;
    }

    public void setAccessMethod(String accessMethod) {
        this.accessMethod = accessMethod;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Inspect
    public void inspectContainer(InspectionContext context) {
        context.addStep((Step)new DummyInspectionStep1(this));
        context.addStep((Step)new DummyInspectionStep2(this));
    }

    class DummyInspectionStep2
    implements Step {
        DummyHost dummyHost;

        public DummyInspectionStep2(DummyHost dummyHost) {
            this.dummyHost = dummyHost;
        }

        public String getDescription() {
            return "Inspecting DummyJeeQueue on " + DummyHost.this.getId();
        }

        public StepExitCode execute(ExecutionContext context) throws Exception {
            DummyHost.this.setOs("hoefnix");
            DummyHost.this.setAccessMethod("ssh");
            DummyJeeQueue queue = new DummyJeeQueue();
            queue.setId(DummyHost.this.getId() + "/DummyJeeQueue3");
            queue.setHost(this.dummyHost);
            context.getInspectionContext().discovered((ConfigurationItem)queue);
            context.getInspectionContext().inspected((ConfigurationItem)queue);
            return StepExitCode.SUCCESS;
        }

        public int getOrder() {
            return 20;
        }
    }

    class DummyInspectionStep1
    implements Step {
        DummyHost dummyHost;

        public DummyInspectionStep1(DummyHost dummyHost) {
            this.dummyHost = dummyHost;
        }

        public String getDescription() {
            return "Inspecting DummyHost on " + DummyHost.this.getId();
        }

        public StepExitCode execute(ExecutionContext context) throws Exception {
            DummyHost.this.setOs("hoefnix");
            DummyHost.this.setAccessMethod("ssh");
            DummyJeeCluster server = new DummyJeeCluster();
            server.setId(DummyHost.this.getId() + "/DummyJeeCluster1");
            server.setHostName(DummyHost.this.address);
            server.setHost((Container)this.dummyHost);
            DummyHost.this.servers.add(server);
            DummyJeeCluster server2 = new DummyJeeCluster();
            server2.setId(DummyHost.this.getId() + "/DummyJeeCluster2");
            server2.setHostName(DummyHost.this.address);
            server2.setHost((Container)this.dummyHost);
            DummyHost.this.servers.add(server2);
            context.getInspectionContext().discovered((ConfigurationItem)server);
            context.getInspectionContext().discovered((ConfigurationItem)server2);
            return StepExitCode.SUCCESS;
        }

        public int getOrder() {
            return 10;
        }
    }
}

