package com.xebialabs.deployit.plugin.test.yak.ci;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.DeleteYakFileFromServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.DeployYakFileToServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.UpgradeYakFileOnServerStep;

@SuppressWarnings("serial")
public class DeployedYakFolder extends BaseDeployed<YakFolder, YakServer> {

    @Modify @Destroy
    public void stop(@SuppressWarnings("unused") DeploymentPlanningContext result) {
        logger.info("Adding stop artifact");
    }

    @Create @Modify
    public void start(@SuppressWarnings("unused") DeploymentPlanningContext result) {
        logger.info("Adding start artifact");
    }

    @Create
    public void deploy(DeploymentPlanningContext result) {
        logger.info("Adding deploy step");
        result.addStep(new DeployYakFileToServerStep((DeployedYakFile) null));
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result) {
        logger.info("Adding upgrade step");
        result.addStep(new UpgradeYakFileOnServerStep((DeployedYakFile) null));
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result) {
        logger.info("Adding undeploy step");
        result.addStep(new DeleteYakFileFromServerStep((DeployedYakFile) null));
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployedYakFolder.class);
}
