package com.xebialabs.deployit.plugin.test.yak.ci;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;

@SuppressWarnings("serial")
@Metadata(virtual = false)
public class DeployedYakPlaceholders extends BaseDeployedArtifact<PlaceholdersYakFile, YakServer> {

	@Property
	private String tempFile;

	@Override
	public void initFile(PlaceholderReplacer replacer) {
		OverthereFile file = getDeployable().getFile();
		InputStreamReader inputStreamReader = new InputStreamReader(file.getInputStream());
		OutputStreamWriter writer = null;
		try {
			File deployedEarModule = File.createTempFile("deployedEarModule", ".txt");
			setFile(LocalFile.valueOf(deployedEarModule));
			writer = new OutputStreamWriter(new FileOutputStream(deployedEarModule));

			replacer.replace(inputStreamReader, writer, getPlaceholders());
		} catch (FileNotFoundException e) {
			throw new RuntimeIOException(e);
		} catch (IOException e) {
			throw new RuntimeIOException(e);
		} finally {
			Closeables.closeQuietly(inputStreamReader);
			Closeables.closeQuietly(writer);
		}
	}

    @Create
	public void createFile(DeploymentPlanningContext ctx) {
		ctx.addStep(new DeploymentStep() {
			@Override
			public int getOrder() {
				return 1;
			}

			@Override
			public String getDescription() {
				return "";
			}

			@Override
			public Result execute(DeploymentExecutionContext ctx) throws Exception {
				OverthereFile file = getFile();
				file.copyTo(LocalFile.valueOf(new File(tempFile)));
				return Result.Success;
			}
		});
	}
}
