package com.xebialabs.deployit.plugin.test.yak.ci;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.LatchStep;

import java.util.concurrent.CountDownLatch;

@SuppressWarnings("serial")
public class DeployedYakBlocker extends BaseDeployed<YakBlocker, YakServer> {

    @Property(required = false)
    private DeployedYakFile deployedYakFile;

    @Modify @Create
    public void create(DeploymentPlanningContext result) {
        result.addStep(new LatchStep(new CountDownLatch(1)));
    }

    public DeployedYakFile getDeployedYakFile() {
        return deployedYakFile;
    }

    public void setDeployedYakFile(DeployedYakFile deployedYakFile) {
        this.deployedYakFile = deployedYakFile;
    }
}
