package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.test.yak.ci.YakServer;

@SuppressWarnings("serial")
public class StartYakServerStep implements DeploymentStep {

    private YakServer server;

    public StartYakServerStep(YakServer server) {
        this.server = server;
    }

    @Override
    public String getDescription() {
        return "Starting " + server;
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
    	// Logic to start server goes here
        return Step.Result.Success;
    }

    public YakServer getServer() {
        return server;
    }

	@Override
	public int getOrder() {
		return 90;
	}
}
